% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatter.r
\name{number_format}
\alias{number_format}
\alias{number}
\alias{comma_format}
\alias{comma}
\alias{percent_format}
\alias{percent}
\alias{unit_format}
\title{Number formatters}
\usage{
number_format(accuracy = 1, scale = 1, prefix = "", suffix = "",
  big.mark = " ", decimal.mark = ".", trim = TRUE, ...)

number(x, accuracy = 1, scale = 1, prefix = "", suffix = "",
  big.mark = " ", decimal.mark = ".", trim = TRUE, ...)

comma_format(accuracy = 1, scale = 1, prefix = "", suffix = "",
  big.mark = ",", decimal.mark = ".", trim = TRUE, digits, ...)

comma(x, accuracy = 1, scale = 1, prefix = "", suffix = "",
  big.mark = ",", decimal.mark = ".", trim = TRUE, digits, ...)

percent_format(accuracy = NULL, scale = 100, prefix = "",
  suffix = "\%", big.mark = " ", decimal.mark = ".", trim = TRUE,
  ...)

percent(x, accuracy = NULL, scale = 100, prefix = "",
  suffix = "\%", big.mark = " ", decimal.mark = ".", trim = TRUE,
  ...)

unit_format(accuracy = 1, scale = 1, prefix = "", unit = "m",
  sep = " ", suffix = paste0(sep, unit), big.mark = " ",
  decimal.mark = ".", trim = TRUE, ...)
}
\arguments{
\item{accuracy}{Number to round to, \code{NULL} for automatic guess.}

\item{scale}{A scaling factor: \code{x} will be multiply by \code{scale} before
formating (useful if the underlying data is on another scale,
e.g. for computing percentages or thousands).}

\item{prefix, suffix}{Symbols to display before and after value.}

\item{big.mark}{Character used between every 3 digits to separate thousands.}

\item{decimal.mark}{The character to be used to indicate the numeric
decimal point.}

\item{trim}{Logical, if \code{FALSE}, values are right-justified to a common
width (see \code{\link[base:format]{base::format()}}).}

\item{...}{Other arguments passed on to \code{\link[base:format]{base::format()}}.}

\item{x}{A numeric vector to format.}

\item{digits}{Deprecated, use \code{accuracy} instead.}

\item{unit}{The units to append.}

\item{sep}{The separator between the number and the unit label.}
}
\value{
\code{*_format()} returns a function with single parameter
\code{x}, a numeric vector, that returns a character vector.
}
\description{
A set of functions to format numeric values:
\itemize{
\item \code{number_format()} and \code{number()} are generic formatters for numbers.
\item \code{comma_format()} and \code{comma()} format numbers with commas separating
thousands.
\item \code{percent_format()} and \code{percent()} multiply values by one hundred and
display percent sign.
\item \code{unit_format()} add units to the values.
}

All formatters allow you to re-\code{scale} (multiplicatively), to round to
specified \code{accuracy}, to add custom \code{suffix} and \code{prefix} and to specify
\code{decimal.mark} and \code{big.mark}.
}
\examples{
# number()
v <- c(12.3, 4, 12345.789, 0.0002)
number(v)
number(v, big.mark = ",")
number(v, accuracy = .001)
number(v, accuracy = .001, decimal.mark = ",")
number(v, accuracy = .5)

# number_format()
my_format <- number_format(big.mark = "'", decimal.mark = ",")
my_format(v)

# comma() and comma_format()
comma_format()(c(1, 1e3, 2000, 1e6))
comma_format(accuracy = .01)(c(1, 1e3, 2000, 1e6))
comma(c(1, 1e3, 2000, 1e6))

# percent() and percent_format()
percent_format()(runif(10))
percent(runif(10))

per_mille <- percent_format(
  scale = 1000,
  suffix = "\\u2030",
  accuracy = .1
)
per_mille(.1234)

french_percent <- percent_format(
  decimal.mark = ",",
  suffix = " \%"
)
french_percent(runif(10))

# unit_format()
# labels in kilometer when the raw data are in meter
km <- unit_format(unit = "km", scale = 1e-3, digits = 2)
km(runif(10) * 1e3)

# labels in hectares, raw data in square meters
ha <- unit_format(unit = "ha", scale = 1e-4)
km(runif(10) * 1e5)

}
