% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{calc_sumZscore}
\alias{calc_sumZscore}
\title{Calc_sumZscore}
\usage{
calc_sumZscore(metric_df_list, batch_key)
}
\arguments{
\item{metric_df_list}{a list of data.frames generated by applying \code{\link{run_all_metrics}} to multiple
sets of integrations}

\item{batch_key}{name of batch column in metadata used when generating run_all_metrics}
}
\value{
a vector of aggregated, z-scored metrics
}
\description{
Aggregate multiple integration metrics across multiple integration runs, ie from different
    batch correction algorithms, or different parameters for the same algorithms
}
\examples{
\donttest{
library(scPOP)
data(sceiad_subset_data)

features <- sceiad_subset_data[, paste0('scviDim_', 1:8)]
metadata_1 <- sceiad_subset_data[,c('Barcode', 'cluster',  'subcluster',
                                  'batch', 'CellType', 'CellType_predict')]

## scramble example dataset to generate multiple integration runs
metadata_2 <- metadata_1
metadata_2$batch <- sample(metadata_2$batch, length(metadata_2$batch))
metadata_2$CellType_predict <- sample(metadata_2$CellType_predict,
                                   length(metadata_2$CellType_predict))
metadata_2$cluster <- sample(metadata_2$cluster, length(metadata_2$cluster))

metadata_3 <- metadata_1
metadata_3$batch <- sample(metadata_3$batch, length(metadata_3$batch))
metadata_3$CellType_predict <- sample(metadata_3$CellType_predict,
                                  length(metadata_3$CellType_predict))
metadata_3$cluster <- sample(metadata_3$cluster, length(metadata_3$cluster))
integration_data_list <- list( metadata_1, metadata_2, metadata_3)
metric_df_list <- lapply(integration_data_list, function(x)
                          run_all_metrics(reduction = features,
                          metadata = x,
                          batch_key = 'batch',
                          label1_key = 'CellType_predict',
                          label2_key = 'cluster',
                          run_name = 'example',
                          quietly =TRUE
                          )
                        )

 calc_sumZscore(metric_df_list,'batch' )
 }
}
