% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/two_method_pathway_enrichment.R
\name{two_method_pathway_enrichment}
\alias{two_method_pathway_enrichment}
\title{two_method_pathway_enrichment}
\usage{
two_method_pathway_enrichment(
  DEGs,
  theSpecies,
  scMappR_vals,
  background_genes = NULL,
  output_directory = "output",
  plot_names = "reweighted",
  number_genes = -9,
  newGprofiler = FALSE,
  toSave = FALSE,
  path = NULL
)
}
\arguments{
\item{DEGs}{Differentially expressed genes (gene_name, padj, log2fc).}

\item{theSpecies}{Human, mouse, or a charcter that is compatible with gProfileR.}

\item{scMappR_vals}{cell weighted Fold-changes of differentially expressed genes.}

\item{background_genes}{A list of background genes to test against. NULL assumes all genes in gprofiler gene set databases.}

\item{output_directory}{Path to the directory where files will be saved.}

\item{plot_names}{Names of output.}

\item{number_genes}{Number of genes to if there are many, many DEGs.}

\item{newGprofiler}{Whether to use gProfileR or gprofiler2 (T/F).}

\item{toSave}{Allow scMappR to write files in the current directory (T/F).}

\item{path}{If toSave == TRUE, path to the directory where files will be saved.}
}
\value{
List with the following elements:
\item{rank_increase}{A list containing the degree of rank change between bulk DE genes and cwFold-changes. Pathway enrichment and tf enrichment of these reranked genes.}
\item{non_rank_increase}{list of DFs containing the pathway and TF enrichment of cwFold-changes.}
}
\description{
Pathway analysis of each cell-type based on cell-type specificity and rank improvement by scMappR.
}
\details{
This function re-ranks cwFoldChanges based on their absolute ct specificity scores (per-celltype) as well as their rank increase in cell-type specificity before completing an ordered pathway analysis. In the second method, only genes with a rank increase in cell-type specificity were included
}
\examples{
\donttest{

# load data for scMappR
data(PBMC_example)
bulk_DE_cors <- PBMC_example$bulk_DE_cors
bulk_normalized <- PBMC_example$bulk_normalized
odds_ratio_in <- PBMC_example$odds_ratio_in
case_grep <- "_female"
control_grep <- "_male"
max_proportion_change <- 10
print_plots <- FALSE
theSpecies <- "human"

# calculate cwFold-changes
toOut <- scMappR_and_pathway_analysis(bulk_normalized, odds_ratio_in, 
                                      bulk_DE_cors, case_grep = case_grep,
                                      control_grep = control_grep, rda_path = "", 
                                      max_proportion_change = 10, print_plots = TRUE, 
                                      plot_names = "tst1", theSpecies = "human", 
                                      output_directory = "tester",
                                      sig_matrix_size = 3000, up_and_downregulated = FALSE, 
                                      internet = FALSE)

# complete pathway enrichment using both methods
twoOutFiles <- two_method_pathway_enrichment(bulk_DE_cors, "human",
scMappR_vals = toOut$cellWeighted_Foldchange, background_genes = rownames(bulk_normalized), 
output_directory = "newfun_test",plot_names = "nonreranked_", toSave = FALSE)

}
 
}
