% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gProfiler_cellWeighted_Foldchange.R
\name{gProfiler_cellWeighted_Foldchange}
\alias{gProfiler_cellWeighted_Foldchange}
\title{Pathway enrichment for cwFold-changes}
\usage{
gProfiler_cellWeighted_Foldchange(
  cellWeighted_Foldchange_matrix,
  species,
  background,
  gene_cut,
  newGprofiler
)
}
\arguments{
\item{cellWeighted_Foldchange_matrix}{Matrix of cell weighted Fold changes from the deconvolute_and_contextualize functions.}

\item{species}{Human, mouse, or a charcter that is compatible with gProfileR.}

\item{background}{A list of background genes to test against.}

\item{gene_cut}{The top number of genes in pathway analysis.}

\item{newGprofiler}{Using gProfileR or gprofiler2, (T/F).}
}
\value{
List with the following elements:
\item{BP}{gprofiler enrichment of biological pathways for each cell-type}
\item{TF}{gprofiler enrichment of transcription factors for eachc cell-type.}
}
\description{
This function runs through each list of cell weighted Fold changes (cwFold-changes) and completes both pathway and transcription factor (TF) enrichment.
}
\details{
This function takes a matrix of cellWeighted_Foldchange and a species (human, mouse, or a character directly compatible with g:ProfileR).
Before completing pathway analysis with g:ProfileR. Enriched pathways are stored in a list and returned.
}
\examples{
\donttest{

data(PBMC_example)

bulk_DE_cors <- PBMC_example$bulk_DE_cors
bulk_normalized <- PBMC_example$bulk_normalized
odds_ratio_in <- PBMC_example$odds_ratio_in

case_grep <- "_female"
control_grep <- "_male"
max_proportion_change <- 10
print_plots <- FALSE
theSpecies <- "human"
norm <- deconvolute_and_contextualize(bulk_normalized, odds_ratio_in,
                                      bulk_DE_cors, case_grep = case_grep, 
                                      control_grep = control_grep,
                                       max_proportion_change = max_proportion_change,
                                       print_plots = print_plots,
                                       theSpecies = theSpecies)
background = rownames(bulk_normalized)
STVs <- gProfiler_cellWeighted_Foldchange(norm$cellWeighted_Foldchange, theSpecies,
 background, gene_cut = -9, newGprofiler = FALSE)

 }
 
}
