% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_tucker.R
\name{plot_donor_matrix}
\alias{plot_donor_matrix}
\title{Plot matrix of donor scores extracted from Tucker decomposition}
\usage{
plot_donor_matrix(
  container,
  meta_vars = NULL,
  cluster_by_meta = NULL,
  show_donor_ids = FALSE,
  add_meta_associations = NULL,
  show_var_explained = TRUE,
  donors_sel = NULL,
  h_w = NULL
)
}
\arguments{
\item{container}{environment Project container that stores sub-containers
for each cell type as well as results and plots from all analyses}

\item{meta_vars}{character Names of metadata variables to plot alongside
the donor scores. Can include more than one variable. (default=NULL)}

\item{cluster_by_meta}{character One metadata variable to cluster the heatmap
by. If NULL, donor clustering is done using donor scores. (default=NULL)}

\item{show_donor_ids}{logical Set to TRUE to show donor id as row name on the
heamap (default=FALSE)}

\item{add_meta_associations}{character Adds meta data associations with each
factor as top annotation. These should be generated first with
plot_meta_associations(). Set to 'pval' if used 'pval' in plot_meta_associations(),
otherwise set to 'rsq'. If NULL, no annotation is added. (default=NULL)}

\item{show_var_explained}{logical Set to TRUE to display the explained variance for
each factor (default=TRUE)}

\item{donors_sel}{character A vector of a subset of donors to include in the plot
(default=NULL)}

\item{h_w}{numeric Vector specifying height and width (defualt=NULL)}
}
\value{
The project container with a heatmap plot of donor scores in container$plots$donor_matrix.
}
\description{
Plot matrix of donor scores extracted from Tucker decomposition
}
\examples{
test_container <- plot_donor_matrix(test_container, show_donor_ids = TRUE)
}
