% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Analysis.R
\name{scDHA.class}
\alias{scDHA.class}
\title{scDHA classification}
\usage{
scDHA.class(
  train = train,
  train.label = train.label,
  test = test,
  ncores = 10L,
  seed = NULL
)
}
\arguments{
\item{train}{Expression matrix of available data, with rows represent samples and columns represent genes.}

\item{train.label}{A vector containing label for each sample in training data.}

\item{test}{Expression matrix new data for classification, with rows represent samples and columns represent genes.}

\item{ncores}{Number of processor cores to use.}

\item{seed}{Seed for reproducibility.}
}
\value{
A vector contain classified labels for new data.
}
\description{
Perform classification of new data based on available data.
}
\examples{
\donttest{
library(scDHA)
#Load example data (Goolam dataset)
data('Goolam'); data <- t(Goolam$data); label <- as.character(Goolam$label)
#Log transform the data 
data <- log2(data + 1)
#Split data into training and testing sets
set.seed(1)
idx <- sample.int(nrow(data), size = round(nrow(data)*0.75))
train.x <- data[idx, ]; train.y <- label[idx]
test.x <- data[-idx, ]; test.y <- label[-idx]
#Predict the labels of cells in testing set
prediction <- scDHA.class(train = train.x, train.label = train.y, test = test.x, 
                          ncores = 2, seed = 1)
#Calculate accuracy of the predictions
acc <- round(sum(test.y == prediction)/length(test.y), 2)
print(paste0("Accuracy = ", acc))
}
}
