% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_list_files.R
\name{item_list_files}
\alias{item_list_files}
\title{Get list of files attached to SB item}
\usage{
item_list_files(sb_id, recursive = FALSE, fetch_cloud_urls = TRUE, ...)
}
\arguments{
\item{sb_id}{An \code{\link{sbitem}} object or a character ScienceBase ID corresponding to the item}

\item{recursive}{(logical) List files recursively. Default: \code{FALSE}}

\item{fetch_cloud_urls}{(logical) fetch a tokenized cloud download URLs? Default: \code{TRUE}
This option will take slightly longer but the `url` attribute of the returned list will
work for direct file downloads or use with pther applications and libraries.}

\item{...}{Additional parameters are passed on to \code{\link[httr]{GET}}, \code{\link[httr]{POST}},
\code{\link[httr]{HEAD}}, \code{\link[httr]{PUT}}.}
}
\value{
A data.frame with columns fname, size, url, and facet. 
If item has no attached files, returns a zero row data.frame.
}
\description{
Lists all files attached to a SB item. Files can be downloaded 
from ScienceBase using \code{\link{item_file_download}}. 

(advanced) Recursive options lists all files attached to an item and all children items. 

NOTE: A sciencebase item can contain so-called "extensions". The 
sciencebase item data model refers to the information that describes
an extension as a "facet". Some extension facets contain files 
(such as with a shapefile). The "facet" attribute of the return from
this function will contain the name of the facet the file came from
if the file was found in a facet.
}
\examples{
\dontrun{

#regular files
item_list_files("4f4e4b24e4b07f02db6aea14")

# files in facets
item_list_files("5f6a285d82ce38aaa244912e")

# list files recursively
## create item
id <- item_create(user_id(), title="some title")
## 1. create nested item w/ file
file <- system.file("examples", "books.json", package = "sbtools")
id2 <- item_create(id, title = "newest-thing")
item_upload_create(id2, file)
## 2. create nested item w/ file
file <- system.file("examples", "species.json", package = "sbtools")
id3 <- item_create(id, title = "a-new-thing")
item_upload_create(id3, file)
## 3. create nested item w/ file
file <- system.file("examples", "data.csv", package = "sbtools")
id4 <- item_create(id, title = "another-thing")
item_upload_create(id4, file)
item_list_files(id = '56562348e4b071e7ea53e09d', recursive = FALSE) # default
item_list_files(id = '56562348e4b071e7ea53e09d', recursive = TRUE)
}
}
