% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_replace_files.R
\name{item_replace_files}
\alias{item_replace_files}
\title{Replace files associated with an item}
\usage{
item_replace_files(sb_id, files, ..., all = FALSE, session = current_session())
}
\arguments{
\item{sb_id}{An \code{\link{sbitem}} object or a character ScienceBase ID corresponding to the item}

\item{files}{A character vector of file paths}

\item{...}{Additional parameters are passed on to \code{\link[httr]{GET}}, \code{\link[httr]{POST}},
\code{\link[httr]{HEAD}}, \code{\link[httr]{PUT}}, or \code{\link[httr]{DELETE}}}

\item{all}{A boolean indicating if all attached files should be removed before
uploading new files. FALSE if only files with matching names should be replaced. 
If you wish to upload files with duplicate names, see \code{\link{item_append_files}}.
Defaults to FALSE.}

\item{session}{Session object from \code{\link{authenticate_sb}}. Defaults to anonymous or 
last authenticated session}
}
\description{
replaces existing files associated with an item with a new one. 
  
NOTE: This function will not replace files stored in facets. Until and if 
facet support is added, direct alteration of the science base item object 
is required to manipulate facets.
}
