% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate.R
\name{validate}
\alias{validate}
\title{sboost Validation Function}
\usage{
validate(features, outcomes, iterations = 1, k_fold = 6,
  positive = NULL)
}
\arguments{
\item{features}{feature set data.frame.}

\item{outcomes}{outcomes corresponding to the features.}

\item{iterations}{number of boosts.}

\item{k_fold}{number of cross-validation subsets.}

\item{positive}{is the positive outcome to test for; if NULL, the first in
alphabetical order will be chosen}
}
\value{
An \emph{sboost_validation} S3 object containing:
\describe{
  \item{\emph{performance}}{Final performance statistics for all stumps.}
  \item{\emph{training_summary_statistics}}{Mean and standard deviations for test statistics
        generated by \code{\link{assess}} cumulative statistics for each of the training sets.}
  \item{\emph{testing_summary_statistics}}{Mean and standard deviations for test statistics
        generated by \code{\link{assess}} cumulative statistics for each of the testing sets.}
  \item{\emph{training_statistics}}{sboost \emph{sboost_assessment} cumulative statistics objects
        used to generate training_statistics.}
  \item{\emph{testing_statistics}}{sboost \emph{sboost_assessment} cumulative statistics objects
        used to generate testing_statistics.}
  \item{\emph{classifier_list}}{sboost \emph{sboost_classifier} objects
        created from training sets.}
  \item{\emph{outcomes}}{Shows which outcome was considered as positive and which negative.}
  \item{\emph{k_fold}}{number of testing and training sets used in the validation.}
  \item{\emph{call}}{Shows the parameters that were used for validation.}
}
}
\description{
A k-fold cross validation algorithm for sboost.
}
\examples{
# malware
validate(malware[-1], malware[1], iterations = 5, k_fold = 3, positive = 1)

# mushrooms
validate(mushrooms[-1], mushrooms[1], iterations = 5, k_fold = 3, positive = "p")
}
\seealso{
\code{\link{sboost}} documentation.
}
