% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAlluvial.R
\name{plotAlluvial}
\alias{plotAlluvial}
\title{Plot an alluvial plot between  clusterings}
\usage{
plotAlluvial(listMemberships, plotOptions = list())
}
\arguments{
\item{listMemberships}{: a list vectors containing the memberships}

\item{plotOptions}{: a list containing the options for Alluvial plots}
}
\value{
display the alluvial plot, returns the plotOptions as a list
}
\description{
Plot an alluvial plot between  clusterings
}
\details{
The list of parameters \code{plotOptions} provides the following options
\itemize{
\item "curvy" numeric, controls the curvature of the alluvial. Default value = 0.3
\item "alpha numeric, vector of transparency of the stripes. Default value = 0.8
\item "gap.width" numeric, relative width of inter-category gaps. Default value = 0.1
\item "col" vector of colors of the stripes. Default value = "darkolivegreen3"
\item "border" vector of border colors for the stripes. Default is white
}
}
\examples{
listMemberships <- list(C1 = rep(c('A','B','C'),each=10),C2 = rep(c(1,2,4),10))
plotAlluvial(listMemberships)
}
