% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6Class-MultipartiteSBM_fit.R
\name{MultipartiteSBM_fit}
\alias{MultipartiteSBM_fit}
\title{R6 Class definition of a Multipartite SBM fit}
\description{
R6 Class definition of a Multipartite SBM fit

R6 Class definition of a Multipartite SBM fit
}
\details{
This class is designed to give a representation and adjust a Multipartite SBM fitted with GREMLIN.

The list of parameters \code{estimOptions} essentially tunes the optimization process and the variational EM algorithm, with the following parameters
\itemize{
\item{"nbCores"}{integer for number of cores used.  Default is 2}
\item{"verbosity"}{integer for verbosity (0, 1). Default is 1}
\item{"nbBlocksRange"}{List of length the number of functional groups, each element supplying the minimal and maximal number of blocks to be explored. The names of the list must be the names of the functional groups.  Default value is from 1 to 10)}
\item{"initBM"}{Boolean. True if using simple and bipartite SBM as initialisations. Default value  = TRUE}
\item{"maxiterVEM"}{Number of max. number of iterations in  the VEM. Default value  = 100}
\item{"maxiterVE"}{Number of max. number of iterations in  the VE. Default value  = 100}
}
}
\section{Super classes}{
\code{\link[sbm:SBM]{sbm::SBM}} -> \code{\link[sbm:MultipartiteSBM]{sbm::MultipartiteSBM}} -> \code{MultipartiteSBM_fit}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{loglik}}{double: approximation of the log-likelihood (variational lower bound) reached}

\item{\code{ICL}}{double: value of the integrated classification log-likelihood}

\item{\code{storedModels}}{data.frame of all models fitted (and stored) during the optimization}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MultipartiteSBM_fit-new}{\code{MultipartiteSBM_fit$new()}}
\item \href{#method-MultipartiteSBM_fit-optimize}{\code{MultipartiteSBM_fit$optimize()}}
\item \href{#method-MultipartiteSBM_fit-predict}{\code{MultipartiteSBM_fit$predict()}}
\item \href{#method-MultipartiteSBM_fit-setModel}{\code{MultipartiteSBM_fit$setModel()}}
\item \href{#method-MultipartiteSBM_fit-show}{\code{MultipartiteSBM_fit$show()}}
\item \href{#method-MultipartiteSBM_fit-clone}{\code{MultipartiteSBM_fit$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="sbm" data-topic="SBM" data-id="rNetwork"><a href='../../sbm/html/SBM.html#method-SBM-rNetwork'><code>sbm::SBM$rNetwork()</code></a></span></li>
<li><span class="pkg-link" data-pkg="sbm" data-topic="MultipartiteSBM" data-id="plot"><a href='../../sbm/html/MultipartiteSBM.html#method-MultipartiteSBM-plot'><code>sbm::MultipartiteSBM$plot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="sbm" data-topic="MultipartiteSBM" data-id="print"><a href='../../sbm/html/MultipartiteSBM.html#method-MultipartiteSBM-print'><code>sbm::MultipartiteSBM$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MultipartiteSBM_fit-new"></a>}}
\if{latex}{\out{\hypertarget{method-MultipartiteSBM_fit-new}{}}}
\subsection{Method \code{new()}}{
constructor for Multipartite SBM
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MultipartiteSBM_fit$new(netList)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{netList}}{list of SBM objects}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MultipartiteSBM_fit-optimize"></a>}}
\if{latex}{\out{\hypertarget{method-MultipartiteSBM_fit-optimize}{}}}
\subsection{Method \code{optimize()}}{
estimation of multipartiteSBM via GREMLINS
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MultipartiteSBM_fit$optimize(estimOptions)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{estimOptions}}{options for MultipartiteBM}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MultipartiteSBM_fit-predict"></a>}}
\if{latex}{\out{\hypertarget{method-MultipartiteSBM_fit-predict}{}}}
\subsection{Method \code{predict()}}{
prediction under the currently estimated model
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MultipartiteSBM_fit$predict()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a list of matrices matrix of expected values for each dyad
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MultipartiteSBM_fit-setModel"></a>}}
\if{latex}{\out{\hypertarget{method-MultipartiteSBM_fit-setModel}{}}}
\subsection{Method \code{setModel()}}{
method to select a specific model among the ones fitted during the optimization.
Fields of the current MultipartiteSBM_fit will be updated accordingly.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MultipartiteSBM_fit$setModel(index)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index}}{integer, the index of the model to be selected (row number in storedModels)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MultipartiteSBM_fit-show"></a>}}
\if{latex}{\out{\hypertarget{method-MultipartiteSBM_fit-show}{}}}
\subsection{Method \code{show()}}{
show method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MultipartiteSBM_fit$show(type = "Fit of a Multipartite Stochastic Block Model")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{character used to specify the type of SBM}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MultipartiteSBM_fit-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MultipartiteSBM_fit-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MultipartiteSBM_fit$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
