% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defineSBM.R
\name{defineSBM}
\alias{defineSBM}
\title{Define a network}
\usage{
defineSBM(
  netMat,
  model = "bernoulli",
  type = ifelse(ncol(netMat) == nrow(netMat), "simple", "bipartite"),
  directed = !isSymmetric(netMat),
  dimLabels = c(row = "row", col = "col"),
  covariates = list()
)
}
\arguments{
\item{netMat}{a matrix describing the network: either an adjacency (square) or incidence matrix with possibly weighted entries.}

\item{model}{character describing the model for the relation between nodes (\code{'bernoulli'}, \code{'poisson'}, \code{'gaussian'}, ...). Default is \code{'bernoulli'}.}

\item{type}{Type of the matrix, choice between 'simple' and 'bipartite'}

\item{directed}{logical: is the network directed or not? Only relevant when \code{type} is \code{'Simple'}. Default is \code{TRUE} if \code{netMat} is symmetric, \code{FALSE} otherwise}

\item{dimLabels}{an optional vector of labels for each dimension (in row, in column). Default value = c('row' = row,'col'= col)}

\item{covariates}{a list of matrices with same dimension as mat describing covariates at the edge level. No covariate per Default.}
}
\value{
an object SimpleSBM or BipartiteSBM with the informations required to define a future multipartite network
}
\description{
Define a network
}
\examples{
A <- matrix(rbinom(100,1,.2), 10, 10)
myNet <- defineSBM(A, "poisson", "simple", TRUE, "Actor")
}
