% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate.R
\name{estimateSimpleSBM}
\alias{estimateSimpleSBM}
\title{Estimation of Simple SBMs}
\usage{
estimateSimpleSBM(
  netMat,
  model = "bernoulli",
  directed = !isSymmetric(netMat),
  dimLabels = list(row = "rowLabel", col = "colLabels"),
  covariates = list(),
  estimOptions = list()
)
}
\arguments{
\item{netMat}{a matrix describing the network: either an adjacency (square) or incidence matrix with possibly weighted entries.}

\item{model}{character describing the model for the relation between nodes (\code{'bernoulli'}, \code{'poisson'}, \code{'gaussian'}, ...). Default is \code{'bernoulli'}.}

\item{directed}{logical: is the network directed or not? Only relevant when \code{type} is \code{'Simple'}. Default is \code{TRUE} if \code{netMat} is symmetric, \code{FALSE} otherwise}

\item{dimLabels}{an optional list of labels for each dimension (in row, in column)}

\item{covariates}{a list of matrices with same dimension as mat describing covariates at the edge level. No covariate per Default.}

\item{estimOptions}{a list of parameters controlling the inference algorithm and model selection. See details.}
}
\value{
a list with the estimated parameters. See details...
}
\description{
This function performs variational inference of simple Stochastic Block Models, with various model
for the distribution of the edges:  Bernoulli, Poisson, or Gaussian models.
}
\details{
The list of parameters \code{estimOptions} essentially tunes the optimization process and the variational EM algorithm, with the following parameters
\itemize{
\item{"nbCores"}{integer for number of cores used. Default is 2}
\item{"verbosity"}{integer for verbosity (0, 1). Default is 1}
\item{"plot"}{boolean, should the ICL by dynamically plotted or not. Default is TRUE}
\item{"exploreFactor"}{control the exploration of the number of groups}
\item{"nbBlocksRange"}{minimal and maximal number or blocks explored}
}
}
\examples{
### =======================================
### SIMPLE BINARY SBM (Bernoulli model)

## Graph parameters & Sampling
nbNodes  <- 90
blockProp <- c(.5, .25, .25) # group proportions
means <- diag(.4, 3) + 0.05  # connectivity matrix: affiliation network
connectParam <- list(mean = means)
mySampler <- sampleSimpleSBM(nbNodes, blockProp, connectParam)
adjacencyMatrix <- mySampler$netMatrix

## Estimation
mySimpleSBM <-
  estimateSimpleSBM(adjacencyMatrix, 'bernoulli', estimOptions = list(plot = FALSE))
plot(mySimpleSBM, 'data', ordered = FALSE)
plot(mySimpleSBM, 'data')
plot(mySimpleSBM, 'expected', ordered = FALSE)
plot(mySimpleSBM, 'expected')

### =======================================
### SIMPLE POISSON SBM

## Graph parameters & Sampling
nbNodes  <- 90
blockProp <- c(.5, .25, .25) # group proportions
means <- diag(15., 3) + 5    # connectivity matrix: affiliation network
connectParam <- list(mean = means)
mySampler <- sampleSimpleSBM(nbNodes, blockProp, list(mean = means), model = "poisson")
adjacencyMatrix <- mySampler$netMatrix

## Estimation
mySimpleSBM <- estimateSimpleSBM(adjacencyMatrix, 'poisson', estimOptions = list(plot = FALSE))
plot(mySimpleSBM, 'data', ordered = FALSE)
plot(mySimpleSBM, 'data')
plot(mySimpleSBM, 'expected', ordered = FALSE)
plot(mySimpleSBM, 'expected')

### =======================================
### SIMPLE GAUSSIAN SBM

## Graph parameters & Sampling
nbNodes  <- 90
blockProp <- c(.5, .25, .25)      # group proportions
means <- diag(15., 3) + 5 # connectivity matrix: affiliation network
connectParam <- list(mean = means, var = 2)
mySampler <- sampleSimpleSBM(nbNodes, blockProp, connectParam, model = "gaussian")

## Estimation
mySimpleSBM <- estimateSimpleSBM(mySampler$netMatrix, 'gaussian', estimOptions = list(plot = FALSE))
plot(mySimpleSBM, 'data', ordered = FALSE)
plot(mySimpleSBM, 'data')
plot(mySimpleSBM, 'expected', ordered = FALSE)
plot(mySimpleSBM, 'expected')

}
