% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/satInfo.R
\name{satInfo}
\alias{satInfo}
\alias{getSatDataLayers}
\alias{getSatDataLayer}
\alias{getSatMeta}
\alias{getSatMetaBCDETemplate}
\alias{getSatLog}
\alias{setSatBCDE}
\alias{createSatBCDE}
\alias{addSatMetaParam}
\alias{addSatMetaEntry}
\alias{addSatLog}
\alias{addSatDataLayer}
\alias{addRasterMeta2Sat}
\alias{createRasterMetaData}
\alias{updateRasterMetaData}
\alias{countSatDataLayers}
\alias{getSatParam}
\alias{getSatBCDE}
\alias{getSatBID}
\alias{getSatSID}
\alias{getSatSensor}
\alias{getSatSensorGroup}
\alias{getSatSensorInfo}
\alias{getSatSpectrum}
\alias{getSatBCDESolar}
\alias{getSatBCDEThermal}
\alias{getSatXRes}
\alias{getSatYRes}
\alias{getSatRes}
\alias{getSatType}
\alias{getSatCalib}
\alias{getSatBCDEType}
\alias{getSatBCDEFromType}
\alias{getSatBCDEFromSpectrum}
\alias{getSatBCDESres}
\alias{getSatBCDECalib}
\alias{getSatBCDESolarCalib}
\alias{getSatBCDEThermalCalib}
\alias{getSatBandInfo}
\alias{getSatRadMax}
\alias{getSatRadMin}
\alias{getSatRefMax}
\alias{getSatRefMin}
\alias{getSatESD}
\alias{getSatESUN}
\alias{getSatSZEN}
\alias{getSatSAZM}
\alias{getSatSELV}
\alias{getSatMetaLayer}
\alias{getSatLayerfromData}
\alias{getSatLNBR}
\alias{getSatLMIN}
\alias{getSatLMAX}
\alias{getSatRADA}
\alias{getSatRADM}
\alias{getSatREFA}
\alias{getSatREFM}
\alias{getSatBTK1}
\alias{getSatBTK2}
\alias{getSatPRAD}
\alias{getSatDATE}
\alias{getSatProjection}
\title{Get or access Satellite object information used by various functions}
\usage{
getSatDataLayers(sat, bcde = NULL)

getSatDataLayer(sat, bcde)

getSatMeta(sat, bcde)

getSatMetaBCDETemplate(sat, bcde)

getSatLog(sat)

setSatBCDE(sat, bcde)

createSatBCDE(sat, width = 3, flag = 0, prefix = "B", postfix = "n")

addSatMetaParam(sat, meta_param)

addSatMetaEntry(sat, meta_param)

addSatLog(sat, info = NA_character_, in_bcde = NA_character_,
  out_bcde = NA_character_)

addSatDataLayer(sat, bcde, data, meta_param, info, in_bcde)

addRasterMeta2Sat(sat)

createRasterMetaData(rst)

updateRasterMetaData(sat, bcde)

countSatDataLayers(sat)

getSatParam(sat, param, bcde, return_bcde = TRUE)

getSatBCDE(sat, lnbr)

getSatBID(sat, bcde)

getSatSID(sat)

getSatSensor(sat)

getSatSensorGroup(sat)

getSatSensorInfo(sat)

getSatSpectrum(sat, bcde)

getSatBCDESolar(sat)

getSatBCDEThermal(sat)

getSatXRes(sat, bcde)

getSatYRes(sat, bcde)

getSatRes(sat, bcde)

getSatType(sat, bcde)

getSatCalib(sat, bcde)

getSatBCDEType(sat, bcde, type)

getSatBCDEFromType(sat, type = "VIS")

getSatBCDEFromSpectrum(sat, spectrum = "solar")

getSatBCDESres(sat, bcde, type)

getSatBCDECalib(sat, bcde, calib)

getSatBCDESolarCalib(sat, bcde, calib)

getSatBCDEThermalCalib(sat, bcde, calib)

getSatBandInfo(sat, bcde, return_calib = TRUE)

getSatRadMax(sat, bcde)

getSatRadMin(sat, bcde)

getSatRefMax(sat, bcde)

getSatRefMin(sat, bcde)

getSatESD(sat)

getSatESUN(sat, bcde)

getSatSZEN(sat, bcde)

getSatSAZM(sat, bcde)

getSatSELV(sat, bcde)

getSatMetaLayer(sat, bcde)

getSatLayerfromData(sat, bcde, nbr)

getSatLNBR(sat, bcde)

getSatLMIN(sat, bcde)

getSatLMAX(sat, bcde)

getSatRADA(sat, bcde)

getSatRADM(sat, bcde)

getSatREFA(sat, bcde)

getSatREFM(sat, bcde)

getSatBTK1(sat, bcde)

getSatBTK2(sat, bcde)

getSatPRAD(sat, bcde)

getSatDATE(sat, bcde)

getSatProjection(sat, bcde)
}
\arguments{
\item{sat}{Satellite object (see \code{\link{satellite}}).}

\item{bcde}{Band code.}

\item{width, flag}{Field width and format modifier for automated creation of 
BCDE information, defaults to '3' and '0', respectively. See 
\code{\link{formatC}} for further details.}

\item{prefix, postfix}{Prefix and postfix to be added to the created BCDE 
information.}

\item{meta_param}{Metadata parameters used to document new data layer}

\item{info}{Log information added to metadata}

\item{in_bcde}{BCDE of layer used as input dataset}

\item{out_bcde}{BCDE of layer used as output dataset}

\item{data}{Data layer of a satellite object}

\item{rst}{Input raster::Raster* object from which to extract metadata.}

\item{param}{Parameter of the metadata set (i.e. colname)}

\item{return_bcde}{Return bcde as attribute (TRUE/FALSE)}

\item{lnbr}{Layer number}

\item{type}{Type of the sensor band}

\item{spectrum}{Spectral region, e.g. "solar" or "thermal".}

\item{calib}{Calibration information.}

\item{return_calib}{Return calibration information (TRUE/FALSE)}

\item{nbr}{Return specific data layer selected by number}
}
\value{
Objects of respective type (see \code{\link{satellite}}).
}
\description{
Get information from class Satellite.
}
\details{
The functions are generally self-explaining in that sence that
\code{get*} returns the respective information and \code{set*} sets the
respective information from/in the Satellite object.
 
\code{addSatLog} adds a log entry to the Satellite object.
}
\section{Functions}{
\itemize{
\item \code{getSatDataLayers}: Return Satellite data layers

\item \code{getSatDataLayer}: Return Satellite data layer i

\item \code{getSatMeta}: Return Satellite object metadata

\item \code{getSatMetaBCDETemplate}: Return template for Satellite object metadata which is based on existing band

\item \code{getSatLog}: Return Satellite object log info

\item \code{setSatBCDE}: Set BCDE/data layer names of a Satellite object

\item \code{createSatBCDE}: If not supplied, automatically create BCDE names of a Satellite object

\item \code{addSatMetaParam}: Add additional or overwrite metainformation parameter to Satellite object

\item \code{addSatMetaEntry}: Add metainformation for an additional layer to Satellite object

\item \code{addSatLog}: Add new log entry to Satellite object

\item \code{addSatDataLayer}: Add new Satellite data layer

\item \code{addRasterMeta2Sat}: Add raster meta data to Satellite object meta data

\item \code{createRasterMetaData}: Create raster meta data

\item \code{updateRasterMetaData}: Create raster meta data

\item \code{countSatDataLayers}: Return number of Satellite data layers

\item \code{getSatParam}: Return parameter (general method implemented by the specific functions below)

\item \code{getSatBCDE}: Return Band code

\item \code{getSatBID}: Return Band IDs

\item \code{getSatSID}: Return sensor ID

\item \code{getSatSensor}: Return sensor

\item \code{getSatSensorGroup}: Return sensor group

\item \code{getSatSensorInfo}: Return sensor information

\item \code{getSatSpectrum}: Return spectrum

\item \code{getSatBCDESolar}: Return solar band codes

\item \code{getSatBCDEThermal}: Return thermal band codes

\item \code{getSatXRes}: Return sensor x resolution

\item \code{getSatYRes}: Return sensor y resolution

\item \code{getSatRes}: Return mean sensor resolution (mean of x and y res)

\item \code{getSatType}: Return sensor type

\item \code{getSatCalib}: Return calibration level

\item \code{getSatBCDEType}: Return TYPE band codes

\item \code{getSatBCDEFromType}: Return BCDE matching TYPE

\item \code{getSatBCDEFromSpectrum}: Return BCDE matching TYPE

\item \code{getSatBCDESres}: Return the mean of x and y resolution for band codes matching type

\item \code{getSatBCDECalib}: Return calibration level for band codes matching type

\item \code{getSatBCDESolarCalib}: Return calibration level for band codes machting type and are solar bands

\item \code{getSatBCDEThermalCalib}: Return calibration level for band codes machting type and are thermal bands

\item \code{getSatBandInfo}: Return band information

\item \code{getSatRadMax}: Return maximum radiance for bcde

\item \code{getSatRadMin}: Return minimum radiance for bcde

\item \code{getSatRefMax}: Return maximum reflectance for bcde

\item \code{getSatRefMin}: Return minimum reflectance for bcde

\item \code{getSatESD}: Return earth-sun distance

\item \code{getSatESUN}: Return actual solar TOA irradiance

\item \code{getSatSZEN}: Return sun zenith angle

\item \code{getSatSAZM}: Return sun azimuth angle

\item \code{getSatSELV}: Return Sun elevation

\item \code{getSatMetaLayer}: Return Layer name from metadata

\item \code{getSatLayerfromData}: Return Layer name from data layer

\item \code{getSatLNBR}: Return Layer number

\item \code{getSatLMIN}: Return minimum wavelength of the sensor band

\item \code{getSatLMAX}: Return maximum wavelength of the sensor band

\item \code{getSatRADA}: Return addition coefficient for SC to radiance conversion

\item \code{getSatRADM}: Return multiplicative coefficient for SC to radiance conversion

\item \code{getSatREFA}: Return addition coefficient for SC to reflectance

\item \code{getSatREFM}: Return multiplicative coefficient for SC to reflectance

\item \code{getSatBTK1}: Return calibration coefficent to convert SC to brightness temperature

\item \code{getSatBTK2}: Return calibration coefficent to convert SC to brightness temperature

\item \code{getSatDATE}: Return DATE

\item \code{getSatProjection}: Return projection
}}

\examples{
# List of input files
path <- system.file("extdata", package = "satellite")
files <- list.files(path, pattern = glob2rx("LC08*.TIF"), full.names = TRUE)
sat <- satellite(files)

# Raster stack l8
sat <- satellite(l8)

}
