% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sar_koba.R
\name{sar_koba}
\alias{sar_koba}
\title{Fit the Kobayashi model}
\usage{
sar_koba(data, start = NULL, grid_start = FALSE, grid_n = NULL, normaTest = 'lillie',
  homoTest = 'cor.fitted')
}
\arguments{
\item{data}{A dataset in the form of a dataframe with two columns: 
the first with island/site areas, and the second with the species richness
of each island/site.}

\item{start}{NULL or custom parameter start values for the optimisation algorithm.}

\item{grid_start}{Logical argument specifying whether a grid search procedure should be implemented to test multiple starting parameter values. The default is set to FALSE, but for certain models (e.g. Gompertz, Chapman Richards), we advice using it to ensure an optimal fit.}

\item{grid_n}{If \code{grid_start = TRUE}, the number of points sampled in the model parameter space.}

\item{normaTest}{The test used to test the normality of the residuals of the
model. Can be any of 'lillie' (Lilliefors Kolmogorov-Smirnov test; the
default), 'shapiro' (Shapiro-Wilk test of normality), 'kolmo'
(Kolmogorov-Smirnov test), or 'none' (no residuals normality test is undertaken).}

\item{homoTest}{The test used to check for homogeneity of the residuals of
the model. Can be any of 'cor.fitted' (a correlation of the residuals with
the model fitted values; the default), 'cor.area' (a correlation of the
residuals with the area values), or 'none' (no residuals homogeneity test is undertaken).}
}
\value{
A list of class 'sars' with the following components: 
  \itemize{
    \item{par} { The model parameters}
    \item{value} { Residual sum of squares}
    \item{counts} {  The number of iterations for the convergence of the fitting algorithm}
    \item{convergence} { Numeric code indicating model convergence (0 = converged)}
    \item{message} { Any message from the model fit algorithm}
    \item{hessian} { A symmetric matrix giving an estimate of the Hessian at the solution found}
    \item{verge} { Logical code indicating model convergence}
    \item{startValues} { The start values for the model parameters used in the optimisation}
    \item{data} { Observed data}
    \item{model} { A list of model information (e.g. the model name and formula)}
    \item{calculated} {  The fitted values of the model}
    \item{residuals} { The model residuals}
    \item{AIC} { The AIC value of the model}
    \item{AICc} { The AICc value of the model}
    \item{BIC} { The BIC value of the model}
    \item{R2} { The R2 value of the model}
    \item{R2a} { The adjusted R2 value of the model}
    \item{sigConf} { The model coefficients table}
    \item{normaTest} { The results of the residuals normality test}
    \item{homoTest} { The results of the residuals homogeneity test}
    \item{observed_shape} { The observed shape of the model fit}
    \item{asymptote} { A logical value indicating whether the observed fit is asymptotic}
    \item{neg_check} { A logical value indicating whether negative fitted values have been returned}}
  The \code{\link{summary.sars}} function returns a more useful summary of
  the model fit results, and the \code{\link{plot.sars}} plots the model fit.
}
\description{
Fit the Kobayashi model to SAR data.
}
\details{
The model is fitted using non-linear regression. The model parameters are estimated
  by minimizing the residual sum of squares with an unconstrained Nelder-Mead optimization algorithm
  and the \code{\link{optim}} function. To avoid numerical problems and speed up the convergence process,
  the starting values used to run the optimization algorithm are carefully chosen. However, if this does
not work, custom values can be provided (using the \code{start} argument), or a more comprehensive search
  can be undertaken using the \code{grid_start} argument. See the vignette for more information.
  The fitting process also determines the observed shape of the model fit,
  and whether or not the observed fit is asymptotic (see Triantis et al. 2012 for further details).
  Model validation is undertaken by assessing the normality (\code{normaTest}) and homogeneity (\code{homoTest})
  of the residuals and a warning is provided in \code{\link{summary.sars}} if either test is failed.
  A selection of information criteria (e.g. AIC, BIC) are returned and can be used to compare models
  (see also \code{\link{sar_average}})
}
\examples{
data(galap)
fit <- sar_koba(galap)
summary(fit)
plot(fit)
}
\references{
Triantis, K.A., Guilhaumon, F. & Whittaker, R.J. (2012) The island species-area
  relationship: biology and statistics. Journal of Biogeography, 39, 215-231.
}
