% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfn_data_methods.R
\docType{methods}
\name{sfn_multi_get_methods}
\alias{sfn_multi_get_methods}
\alias{get_sapf_data,sfn_data_multi-method}
\alias{get_env_data,sfn_data_multi-method}
\alias{get_sapf_flags,sfn_data_multi-method}
\alias{get_env_flags,sfn_data_multi-method}
\alias{get_timestamp,sfn_data_multi-method}
\alias{get_solar_timestamp,sfn_data_multi-method}
\alias{get_si_code,sfn_data_multi-method}
\alias{get_site_md,sfn_data_multi-method}
\alias{get_stand_md,sfn_data_multi-method}
\alias{get_species_md,sfn_data_multi-method}
\alias{get_plant_md,sfn_data_multi-method}
\alias{get_env_md,sfn_data_multi-method}
\title{sfn_data_multi get methods}
\usage{
\S4method{get_sapf_data}{sfn_data_multi}(object, solar = FALSE)

\S4method{get_env_data}{sfn_data_multi}(object, solar = FALSE)

\S4method{get_sapf_flags}{sfn_data_multi}(object, solar = FALSE)

\S4method{get_env_flags}{sfn_data_multi}(object, solar = FALSE)

\S4method{get_timestamp}{sfn_data_multi}(object)

\S4method{get_solar_timestamp}{sfn_data_multi}(object)

\S4method{get_si_code}{sfn_data_multi}(object)

\S4method{get_site_md}{sfn_data_multi}(object, collapse = FALSE)

\S4method{get_stand_md}{sfn_data_multi}(object, collapse = FALSE)

\S4method{get_species_md}{sfn_data_multi}(object, collapse = FALSE)

\S4method{get_plant_md}{sfn_data_multi}(object, collapse = FALSE)

\S4method{get_env_md}{sfn_data_multi}(object, collapse = FALSE)
}
\arguments{
\item{object}{Object of class sfn_data_multi from which data or metadata is
retrieved}

\item{solar}{Logical indicating if the timestamp to return in the \code{get_sapf_data},
\code{get_env_data}, \code{get_sapf_flags} and \code{get_env_flags} methods is
the solarTIMESTAMP (TRUE) or the contributors provided TIMESTAMP (FALSE)}

\item{collapse}{Logical indicating if the metadata get methods must collapse
the returning list to a data frame with all sites}
}
\description{
Methods to get the data and metadata from the sfn_data class slots
}
\details{
\code{get_sapf_data} and \code{get_env_data} methods retrieve sapflow or
environmental tibbletimes from the sfn_data objects contained in the 
sfn_data_multi and return them in a list.

\code{get_sapf_flags} and \code{get_env_flags} methods retrieve sapflow or
environmental flags tibbletimes from the sfn_data objects contained in the 
sfn_data_multi and return them in a list.

\code{get_timestamp} and \code{get_solar_timestamp} methods retrieve only the
timestamps as POSIXct vectors and return them as a list (each element
corresponding to a site in the sfn_data_multi object).

\code{get_si_code} method retrieve a character vector with length(timestamp)
containing the site code for each site, returning them as a list.

\code{get_site_md}, \code{get_stand_md}, \code{get_species_md},
\code{get_plant_md} and \code{get_env_md} methods retrieve the corresponding
metadata objects for each site returning them as a list, unless collapse is
TRUE, then the list collapses to a tibble.
}
\examples{
library(dplyr)

}
