% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels.R
\name{lbl_manual}
\alias{lbl_manual}
\title{Label manually in sequence}
\usage{
lbl_manual(sequence, fmt = "\%s")
}
\arguments{
\item{sequence}{A character vector of labels.}

\item{fmt}{A \code{\link[=sprintf]{sprintf()}}-style format.}
}
\value{
A vector of labels for \code{chop}, or a function that creates labels.
}
\description{
\code{lbl_manual()} uses an arbitrary sequence to label
intervals. If the sequence is too short, it will be pasted with itself and
repeated.
}
\examples{
chop(1:10, c(2, 5, 8), lbl_manual(c("w", "x", "y", "z")))

# if labels need repeating:
chop(1:10, 1:10, lbl_manual(c("x", "y", "z")))
}
\seealso{
Other labelling functions: 
\code{\link{lbl_dash}()},
\code{\link{lbl_format}()},
\code{\link{lbl_intervals}()},
\code{\link{lbl_seq}()}
}
\concept{labelling functions}
