% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solve_direct.R
\name{solve_chol}
\alias{solve_chol}
\alias{solve_lu}
\alias{solve_qr}
\title{Solve a System of Equations Using Direct Methods}
\usage{
solve_chol(a, b)

solve_lu(a, b)

solve_qr(a, b)
}
\arguments{
\item{a}{Square numeric matrix with the coefficients of the linear system.
Both dense and sparse matrices are supported (see \link{sparsify}).}

\item{b}{Numeric vector or matrix at the right-hand side of the linear
system. If missing, 'b' is set to an identity matrix and 'a' is
inverted.}
}
\value{
Solves for \eqn{x} and returns a numeric matrix with the results.
}
\description{
Functions to access specific direct solvers for systems of equations.
}
\examples{
# Solve via LU and QR for general matrices
A <- matrix(rnorm(9), nrow = 3, ncol = 3)
x <- rnorm(3)
b  <- A \%*\% x

x_lu <- solve_lu(A, b)
x_qr <- solve_qr(A, b)

# Solve via Cholesky for symmetric matrices
AA <- crossprod(A)
b <- AA \%*\% x

x_chol <- solve_chol(AA, b)

# Sparse methods are available for the 'dgCMatrix' class from Matrix
x_slu <- solve_lu(sparsify(A), b)

}
