% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Z_identities.R
\name{Mean_Variance}
\alias{Mean_Variance}
\title{Mean Variance Estimates}
\usage{
Mean_Variance(rawData, idCol)
}
\arguments{
\item{rawData}{Dataframe with the following column variables for N repetitions of each unique query: participant ID ('id'), response query 1, response query 2, ... , response query N}

\item{idCol}{Name of the 'ID' column.}
}
\value{
A dataframe with values for the intercept (b0) and slope (b1) of the estimated regression, as well as estimates for N, d, and beta (termed b in the paper) for each participant.
}
\description{
Estimates number of samples and prior parameters of the Bayesian Sampler using the Mean/Variance relationship as shown by \insertCite{sundh2023UnifiedExplanationVariability}{samplr}. For consistency with the Bayesian Sampler function we call beta the prior parameter, and b0 and b1 slope and intercept respectively.
}
\examples{
library(dplyr)
library(tidyr)
library(magrittr)
library(samplrData)
data <- sundh2023.meanvariance.e3 \%>\%
  group_by(ID, querydetail) \%>\% 
  mutate(iteration = LETTERS[1:n()]) \%>\% 
  pivot_wider(id_cols = c(ID, querydetail), 
      values_from = estimate, names_from = iteration) \%>\% 
  mutate(across(where(is.numeric), \(x){x/100})) \%>\% 
  ungroup \%>\% 
  select(-querydetail)
head(data)
head(Mean_Variance(data, "ID"))
}
