% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psampcalc.R
\name{psampcalc}
\alias{psampcalc}
\title{Determines sample size by strata using sub-units}
\usage{
psampcalc(df, n, strata, unit, over = 0)
}
\arguments{
\item{df}{object containing full sampling data frame (e.g. data)}

\item{n}{sample size (integer) or object containing sample size}

\item{strata}{variable in sampling data frame by which to stratify (e.g. region)}

\item{unit}{variable in sampling data frame containing sub-units (e.g. population)}

\item{over}{(optional) desired oversampling proportion (defaults to 0; takes value between 0 and 1 as input)}
}
\value{
Returns sample size per strata based on sub-units (rounded up to nearest integer)
}
\description{
Determines sample size by strata using sub-units
}
\references{
[1] Sampling Design & Analysis, S. Lohr, 1999, 4.4
}
