% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dlso.R
\name{dlso}
\alias{dlso}
\title{Latent Structure Optimization Based on Draws}
\usage{
dlso(partitions, loss = VI(), x = NULL)
}
\arguments{
\item{partitions}{An integer matrix of cluster labels with \eqn{n} columns,
where each row is a partition of \eqn{n} items given as cluster labels. Two
items are in the same subset (i.e., cluster) if their labels are equal. Or,
a vector of length \eqn{n} which will be converted to a \eqn{1}-by-\eqn{n}
matrix.}

\item{loss}{The loss function to use, as indicated by \code{"binder"},
\code{"omARI"}, \code{"VI"}, \code{"NVI"}, \code{"ID"}, \code{"NID"}, or
the result of calling a function with these names. Also supported are
\code{"binder.psm"}, \code{"VI.lb"}, \code{"omARI.approx"}, or the result
of calling a function with these names, in which case \code{x} above can
optionally be a pairwise similarity matrix, i.e., \eqn{n}-by-\eqn{n}
symmetric matrix whose \eqn{(i,j)} element gives the (estimated)
probability that items \eqn{i} and \eqn{j} are in the same subset (i.e.,
cluster) of a partition (i.e., clustering).}

\item{x}{A \eqn{B}-by-\eqn{n} matrix, where each of the \eqn{B} rows
represents a clustering of \eqn{n} items using cluster labels. For the
\eqn{b}th clustering, items \eqn{i} and \eqn{j} are in the same cluster if
\code{x[b,i] == x[b,j]}.}
}
\value{
An integer vector giving the estimated partition, encoded using
  cluster labels.
}
\description{
This function provides a partition to summarize a partition distribution
using the draws-based latent structure optimization (DLSO) method, which is
also known as the least-squares clustering method (Dahl 2006). The method
seeks to minimize an estimation criterion by picking the minimizer among the
partitions supplied. The implementation currently supports the minimization
of several partition estimation criteria. For details on these criteria, see
\code{\link{partition.loss}}.
}
\examples{
dlso(iris.clusterings, loss=VI())
dlso(iris.clusterings, loss=binder())

# Compute expected loss using all draws, but pick the best among the first 10.
dlso(iris.clusterings[1:10,], loss=VI(), x=iris.clusterings)

}
\references{
D. B. Dahl (2006), Model-Based Clustering for Expression Data via a Dirichlet
Process Mixture Model, in \emph{Bayesian Inference for Gene Expression and
Proteomics}, Kim-Anh Do, Peter Müller, Marina Vannucci (Eds.), Cambridge
University Press.
}
\seealso{
\code{\link{partition.loss}}, \code{\link{psm}},
  \code{\link{summary.salso.estimate}}, \code{\link{salso}}
}
