% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bulk-operation.R
\name{sf_close_job_bulk}
\alias{sf_close_job_bulk}
\title{Close Bulk API Job}
\usage{
sf_close_job_bulk(
  job_id,
  api_type = c("Bulk 1.0", "Bulk 2.0"),
  verbose = FALSE
)
}
\arguments{
\item{job_id}{\code{character}; the Salesforce Id assigned to a submitted job as
returned by \link{sf_create_job_bulk}. It will start with \code{"750"}.}

\item{api_type}{\code{character}; one of \code{"REST"}, \code{"SOAP"},
\code{"Bulk 1.0"}, or \code{"Bulk 2.0"} indicating which API to use when
making the request.}

\item{verbose}{\code{logical}; an indicator of whether to print additional
detail for each API call, which is useful for debugging. More specifically, when
set to \code{TRUE} the URL, header, and body will be printed for each request,
along with additional diagnostic information where available.}
}
\value{
A \code{list} of parameters defining the now closed job
}
\description{
This function closes a Job in the Salesforce Bulk API
}
\note{
This is a legacy function used only with Bulk 1.0.
}
\examples{
\dontrun{
my_query <- "SELECT Id, Name FROM Account LIMIT 10"
job_info <- sf_create_job_bulk(operation='query', object='Account')
query_info <- sf_submit_query_bulk(job_id=job_info$id, soql=my_query)
recordset <- sf_query_result_bulk(job_id = query_info$jobId,
                                  batch_id = query_info$id,
                                  result_id = result$result)
sf_close_job_bulk(job_info$id)
}
}
\references{
\url{https://developer.salesforce.com/docs/atlas.en-us.api_asynch.meta/api_asynch/}
}
