% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-query.R
\name{records_list_to_tbl}
\alias{records_list_to_tbl}
\title{Extract tibble based on the "records" element of a list}
\usage{
records_list_to_tbl(x, object_name_append = FALSE, object_name_as_col = FALSE)
}
\arguments{
\item{x}{\code{list}; list of records parsed from JSON.}

\item{object_name_append}{\code{logical}; whether to include the object type
(e.g. Account or Contact) as part of the column names (e.g. Account.Name).}

\item{object_name_as_col}{\code{logical}; whether to include the object type
(e.g. Account or Contact) as a new column.}
}
\value{
\code{tbl_df} a data frame with each row representing a single element
from the "records" element of the list.
}
\description{
This function accepts a list representing the parsed JSON recordset In this
case the records are not nested, but can have relationship fields. Each element
in the "records" element is bound to a single row after dropping the attributes
and then returned as one complete \code{tbl_df} of all records.
}
\note{
This function is meant to be used internally. Only use when debugging.
}
\keyword{internal}
