% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-query.R
\name{compact2}
\alias{compact2}
\title{Remove all zero-length elements from list ignoring AsIs elements}
\usage{
compact2(.x, .p = identity)
}
\arguments{
\item{.x}{\code{list} or \code{vector}}

\item{.p}{\code{function}; predicate function that identifies elements to discard}
}
\value{
\code{list} containing no empty elements, but does leave anything that
has been wrapped in \code{I()} making the class \code{AsIs} which signals
to \code{\link[jsonlite]{toJSON}} not to drop the value, but to set as null.
}
\description{
This function wraps the \code{\link[purrr:keep]{compact}} function to recursively
remove elements from lists that have zero length, but spares the elements wrapped
in \code{\link[base:AsIs]{I}} which mean something specific when passing as JSON.
}
\note{
This function is meant to be used internally. Only use when debugging.
}
\keyword{internal}
