% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bulk-operation.R
\name{sf_abort_job_bulk}
\alias{sf_abort_job_bulk}
\title{Abort Bulk API Job}
\usage{
sf_abort_job_bulk(
  job_id,
  api_type = c("Bulk 1.0", "Bulk 2.0"),
  verbose = FALSE
)
}
\arguments{
\item{job_id}{\code{character}; the Salesforce Id assigned to a submitted job as
returned by \link{sf_create_job_bulk}. It will start with \code{"750"}.}

\item{api_type}{\code{character}; one of \code{"REST"}, \code{"SOAP"},
\code{"Bulk 1.0"}, or \code{"Bulk 2.0"} indicating which API to use when
making the request.}

\item{verbose}{\code{logical}; an indicator of whether to print additional
detail for each API call, which is useful for debugging. More specifically, when
set to \code{TRUE} the URL, header, and body will be printed for each request,
along with additional diagnostic information where available.}
}
\value{
A \code{list} of parameters defining the now aborted job
}
\description{
This function aborts a Job in the Salesforce Bulk API
}
\examples{
\dontrun{
job_info <- sf_create_job_bulk('insert', 'Account')
sf_abort_job_bulk(job_info$id)
}
}
\references{
\url{https://developer.salesforce.com/docs/atlas.en-us.api_asynch.meta/api_asynch/}
}
