% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bulk-query.R
\name{sf_submit_query_bulk}
\alias{sf_submit_query_bulk}
\title{Submit Bulk Query Batch to a Bulk API Job}
\usage{
sf_submit_query_bulk(job_id, soql, api_type = c("Bulk 1.0"), verbose = FALSE)
}
\arguments{
\item{job_id}{character; the Salesforce Id assigned to a submitted job as 
returned by \link{sf_create_job_bulk}}

\item{soql}{character; a string defining a SOQL query (e.g. "SELECT Id, Name FROM Account")}

\item{api_type}{character; one of "REST", "SOAP", "Bulk 1.0", "Bulk 2.0", or 
"Chatter" indicating which API to use when making the request}

\item{verbose}{logical; do you want informative messages?}
}
\value{
A \code{list} parameters of the batch
}
\description{
This function takes a SOQL text string and submits the query to 
an already existing Bulk API Job of operation "query"
}
\note{
Bulk API query doesn't support the following SOQL:
\itemize{
   \item COUNT
   \item ROLLUP
   \item SUM
   \item GROUP BY CUBE
   \item OFFSET
   \item Nested SOQL queries
   \item Relationship fields
   }
Additionally, Bulk API can't access or query compound address or compound geolocation fields.
}
\examples{
\dontrun{
my_query <- "SELECT Id, Name FROM Account LIMIT 1000"
job_info <- sf_create_job_bulk(operation = 'query', object = 'Account')
query_info <- sf_submit_query_bulk(job_id = job_info$id, soql = my_query)
}
}
\references{
\url{https://developer.salesforce.com/docs/atlas.en-us.api_asynch.meta/api_asynch/}
}
