% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{sf_create}
\alias{sf_create}
\title{Create Records}
\usage{
sf_create(
  input_data,
  object_name,
  api_type = c("SOAP", "REST", "Bulk 1.0", "Bulk 2.0"),
  control = list(...),
  ...,
  verbose = FALSE
)
}
\arguments{
\item{input_data}{\code{named vector}, \code{matrix}, \code{data.frame}, or 
\code{tbl_df}; data can be coerced into a \code{data.frame}}

\item{object_name}{character; the name of one Salesforce objects that the 
function is operating against (e.g. "Account", "Contact", "CustomObject__c")}

\item{api_type}{character; one of "REST", "SOAP", "Bulk 1.0", "Bulk 2.0", or 
"Chatter" indicating which API to use when making the request}

\item{control}{\code{list}; a list of parameters for controlling the behavior of 
the API call being used. For more information of what parameters are available 
look at the documentation for \code{\link{sf_control}}}

\item{...}{arguments passed to \code{\link{sf_control}} or further downstream 
to \code{\link{sf_bulk_operation}}}

\item{verbose}{logical; do you want informative messages?}
}
\value{
\code{tbl_df} of records with success indicator
}
\description{
Adds one or more new records to your organization’s data.
}
\note{
Because the SOAP and REST calls chunk data into batches of 200 records 
the AllOrNoneHeader will only apply to the success or failure of every batch 
of records and not all records submitted to the function.
}
\examples{
\dontrun{
n <- 2
new_contacts <- tibble(FirstName = rep("Test", n),
                       LastName = paste0("Contact", 1:n))
new_recs1 <- sf_create(new_contacts, object_name = "Contact")

# add control to allow the creation of records that violate a duplicate rules
new_recs2 <- sf_create(new_contacts, object_name = "Contact", 
                       DuplicateRuleHeader=list(allowSave=TRUE,
                                                includeRecordDetails=FALSE,
                                                runAsCurrentUser=TRUE))
                                                  
# example using the Bulk 1.0 API to insert records
new_recs3 <- sf_create(new_contacts, object_name = "Contact", 
                       api_type = "Bulk 1.0")
}
}
