% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dual-rep-t-aperm.r
\name{t}
\alias{t}
\alias{t.dual}
\alias{aperm}
\alias{aperm.dual}
\title{Transposition of matrices and arrays}
\usage{
\method{t}{dual}(x)

\method{aperm}{dual}(a, perm = NULL, resize = TRUE, ...)
}
\arguments{
\item{x, a}{a dual matrix or array}

\item{perm}{subscript permutation vector}

\item{resize}{if 'TRUE' (default) the array is reshaped}

\item{...}{extra arguments (ignored)}
}
\value{
A dual matrix or array.
}
\description{
Transposition of matrices and arrays
}
\examples{
x <- dual( matrix(c(1,2,0,3), 2, 2) )
t(x)

# creation of an array using dim<-
y <- dual( c(1,-1) ) + 1:12
dim(y) <- c(2,3,2)
z <- aperm(y, c(2,3,1))
z
d(z, "x1")

}
