% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSettingValue.R
\name{getSettingValue}
\alias{getSettingValue}
\title{Retrieve the value for a given named parameter}
\usage{
getSettingValue(key, settings)
}
\arguments{
\item{key}{a list (like those provided by \code{getSettingKeys()}) defining the position of parameter in the settings object.}

\item{settings}{The settings list used to generate a chart like \code{eDISH()}}
}
\value{
the value of the key/settings combo
}
\description{
Returns the value for a named parameter (\code{key}) in a list \code{settings}
}
\examples{
safetyGraphics:::getSettingValue(list("a","b"),list(a=list(b="myValue"))) #returns "myValue"

testSettings<-generateSettings(standard="AdAM")
safetyGraphics:::getSettingValue(list("id_col"),testSettings) 
safetyGraphics:::getSettingValue(list("measure_values","ALP"),testSettings)
safetyGraphics:::getSettingValue(list("NotASetting"),testSettings) #returns NULL

}
