% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tTest.R
\name{safeTTestStatTDensity}
\alias{safeTTestStatTDensity}
\title{safeTTestStat() based on t-densities}
\usage{
safeTTestStatTDensity(
  t,
  parameter,
  nu,
  nEff,
  alternative = c("two.sided", "less", "greater"),
  paired = FALSE,
  ...
)
}
\arguments{
\item{t}{numeric that represents the observed t-statistic.}

\item{parameter}{numeric this defines the safe test S, i.e., a likelihood ratio of t distributions with in
the denominator the likelihood with delta = 0 and in the numerator an average likelihood defined by
1/2 time the likelihood at the non-centrality parameter sqrt(nEff)*parameter and 1/2 times the likelihood at
the non-centrality parameter -sqrt(nEff)*parameter.}

\item{nu}{numeric > 0 representing the degrees of freedom.}

\item{nEff}{numeric > 0 representing the effective sample size in a two-sample problem. For one-sample
problems this is equal to the sample size.}

\item{alternative}{a character only used if pilot equals \code{TRUE}. If pilot equals \code{FALSE},
then the alternative specified by the design object is used instead.}

\item{paired}{a logical indicating whether you want a paired t-test.}

\item{...}{further arguments to be passed to or from methods.}
}
\value{
Returns a numeric that represent the e10, that is, the e-value in favour of the
alternative over the null.
}
\description{
This is basically just \code{\link{safeTTestStat}()} - 1/alpha. This function is used for root finding for
pilot designs.
}
\examples{
safeTTestStat(t=1, n1=100, 0.4)
safeTTestStat(t=3, n1=100, parameter=0.3)
}
