% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlme_methods.R
\name{intervals}
\alias{intervals}
\alias{intervals.NER}
\title{Confidence intervals on coefficients of an 'saeTrafo' object}
\usage{
\method{intervals}{NER}(object, level = 0.95, parm = NULL, ...)
}
\arguments{
\item{object}{an object of type 'NER'.}

\item{level}{an optional numeric value with the confidence level for the
intervals. Defaults to 0.95.}

\item{parm}{vector of names to specify which parameters are to be given
confidence intervals. If \code{NULL}, all parameters are taken into account.
Defaults to \code{NULL}.}

\item{...}{additional arguments that are not used in this method.}
}
\value{
A matrix with rows corresponding to the parameters and columns
containing the lower confidence limits (lower), the
estimated values (est.), and upper confidence limits (upper).
}
\description{
Method \code{intervals.NER} provides the approximate confidence intervals on
the coefficients (fixed effects) of an 'saeTrafo' object.
}
\details{
The generic function \code{intervals} is imported from package
\pkg{nlme} and re-exported to make the S3-methods available, even though the
\pkg{nlme} package itself is not loaded or attached. For default
documentation, see \code{\link[nlme]{intervals}}.
}
\examples{
# Example to extract confidence intervals on coefficients

# Load Data
data("eusilcA_smp")
data("pop_area_size")
data("pop_mean")
data("pop_cov")

# Nested error regression model
NER_model <- NER_Trafo(fixed = eqIncome ~ gender + eqsize + cash +
                       self_empl + unempl_ben + age_ben + surv_ben +
                       sick_ben + dis_ben + rent + fam_allow + house_allow +
                       cap_inv + tax_adj,
                       smp_domains = "district",
                       pop_area_size = pop_area_size,
                       pop_mean = pop_mean, pop_cov = pop_cov,
                       smp_data = eusilcA_smp)

intervals(NER_model)
}
\seealso{
\code{\link{NER_Trafo}}, \code{\link[nlme]{intervals}}
}
