% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sd_via_median_estimator.R
\name{sd_via_median_estimator}
\alias{sd_via_median_estimator}
\title{Compute standard deviation via median estimator.}
\usage{
sd_via_median_estimator(x, na.rm = FALSE)
}
\arguments{
\item{x}{Numeric values}

\item{na.rm}{Whether to exclude NA values, defaults to \code{FALSE}.}
}
\value{
float
}
\description{
Compute standard deviation via median estimator.
Please refer to formula #2 in Engbert & Kliegl (2003).
Falls back on mean estimator, if computed standard deviation
is smaller than \code{.Machine$double.eps}. Raises an error
if the results using the mean estimator is still smaller than
\code{.Machine$double.eps}.
}
\examples{
sd_via_median_estimator(rnorm(100))
}
