% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_nh.R
\name{method_nh}
\alias{method_nh}
\title{Extract saccades using an algorithm proposed by Nyström and Holmqvist (2010) \doi{10.3758/BRM.42.1.188}.}
\usage{
method_nh(x, y, vel, acc, sample_rate, trial, options)
}
\arguments{
\item{x}{Gaze x coordinate, _arbitrary units_ as threshold velocity is computed in units of standard deviation.}

\item{y}{Gaze y coordinate, _arbitrary units_ as threshold velocity is computed in units of standard deviation.}

\item{vel}{Velocity \code{data.frame} with columns \code{x}, \code{y}, \code{amp}.}

\item{acc}{Acceleration \code{data.frame} with columns \code{x}, \code{y}, \code{amp}.}

\item{sample_rate}{Sample rate in Hz.}

\item{trial}{Trial id, so that trial borders are respected when computing velocity and saccades.}

\item{options}{Named list with method options. See \emph{details} for  further information.}
}
\value{
logical vector marking samples that belong to saccades
}
\description{
Extract saccades using an algorithm proposed by Nyström and Holmqvist (2010) \doi{10.3758/BRM.42.1.188}.
}
\details{
Method options, please refer to Nyström and Holmqvist (2010) for details on parameters and the rationale for default values.
\itemize{
\item{\code{nh_sg_filter_order}} {Order of Savitzky-Golay filter. Defaults to \code{2}.}
\item{\code{nh_max_velocity}} {Maximal physiologically plausible velocity in °/s. Defaults to \code{1000}.}
\item{\code{nh_max_acceleration}} {Maximal physiologically plausible acceleration in °/s². Defaults to \code{100000}.}
\item{\code{nh_initial_velocity_threshold}} {Initial velocity threshold in °/s. Defaults to \code{100}.}
}
}
\examples{
# Do not run this function directly, use extract_saccades() instead
}
\seealso{
\code{\link{extract_saccades}}
}
