% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sSDR.R
\name{gOLS}
\alias{gOLS}
\title{Groupwise OLS (gOLS)}
\usage{
gOLS(X, Y, groups, Gamma, dims, tol = 1e-05, maxiter = 100)
}
\arguments{
\item{X}{A covariate matrix of n observations and p predictors.}

\item{Y}{A univariate response.}

\item{groups}{A vector with the number of predictors in each group.}

\item{Gamma}{A p x p identity matrix.}

\item{dims}{A vector with the dimension (at most 1) for each predictor group.}

\item{tol}{A tolerence factor in the convergence criterium.}

\item{maxiter}{A maximum iteration number.}
}
\value{
gOLS returns a list containning at least the following components:
"b_init", the initial estimatied directions for each group with its own
dimension using assembled OLS;
"b_est", the estimated directions for each group with its own dimension
using gOLS AFTER normalization;
"B", the estimated directions for each group using gOLS BEFORE normalization;
"t_est", the estimated p-dimensional directions for each group using gOLS
AFTER normalization;
"obj", the objective functions from each iteration;
"niter", the number of iterations.
}
\description{
Groupwise OLS (gOLS)
}
\details{
This function estimates directions for each predictor group using gOLS.
Predictors need to be organized in groups within the "X" matrix, as the
same order saved in "groups". We only allow continuous covariates
in the "X" matrix; while categorical covariates can be handled outside of
gOLS, e.g. structured OLS.
"b_est", "B", and "t_est" are basically the same estimation with different
layouts and/or normalizations.
}
\examples{
data <- gen.data(n=1000, binary=FALSE) # generate data
dim(data$X) # covariate matrix of 1000 observations and 15 predictors
dim(data$y) # univariate response
groups <- c(5, 10) # two predictor groups and their numbers of predictors
Gamma <- diag(sum(groups)) # identity matrix
dims <- c(1,1) # dimension of each predictor group
est_gOLS <- gOLS(data$X,data$y,groups,Gamma,dims,tol=1e-5,maxiter=100)
names(est_gOLS)
}
\references{
Liu, Y., Chiaromonte, F., and Li, B. (2015). Structured Ordinary
Least Squares: a sufficient dimension reduction approach for regressions with
 partitioned predictors and heterogeneous units. Submitted.
}

