% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3filesystem_class.R
\name{S3FileSystem}
\alias{S3FileSystem}
\title{Access AWS S3 as if it were a file system.}
\description{
This creates a file system "like" API based off \code{fs}
(e.g. dir_ls, file_copy, etc.) for AWS S3 storage.
}
\note{
This method will only update the modification time of the AWS S3 object.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{s3_cache}}{Cache AWS S3}

\item{\code{s3_cache_bucket}}{Cached s3 bucket}

\item{\code{s3_client}}{paws s3 client}

\item{\code{region_name}}{AWS region when creating new connections}

\item{\code{profile_name}}{The name of a profile to use}

\item{\code{multipart_threshold}}{Threshold to use multipart}

\item{\code{request_payer}}{Threshold to use multipart}

\item{\code{pid}}{Get the process ID of the R Session}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{retries}}{number of retries}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-S3FileSystem-new}{\code{S3FileSystem$new()}}
\item \href{#method-S3FileSystem-file_chmod}{\code{S3FileSystem$file_chmod()}}
\item \href{#method-S3FileSystem-file_copy}{\code{S3FileSystem$file_copy()}}
\item \href{#method-S3FileSystem-file_create}{\code{S3FileSystem$file_create()}}
\item \href{#method-S3FileSystem-file_delete}{\code{S3FileSystem$file_delete()}}
\item \href{#method-S3FileSystem-file_download}{\code{S3FileSystem$file_download()}}
\item \href{#method-S3FileSystem-file_exists}{\code{S3FileSystem$file_exists()}}
\item \href{#method-S3FileSystem-file_info}{\code{S3FileSystem$file_info()}}
\item \href{#method-S3FileSystem-file_move}{\code{S3FileSystem$file_move()}}
\item \href{#method-S3FileSystem-file_size}{\code{S3FileSystem$file_size()}}
\item \href{#method-S3FileSystem-file_stream_in}{\code{S3FileSystem$file_stream_in()}}
\item \href{#method-S3FileSystem-file_stream_out}{\code{S3FileSystem$file_stream_out()}}
\item \href{#method-S3FileSystem-file_temp}{\code{S3FileSystem$file_temp()}}
\item \href{#method-S3FileSystem-file_tag_delete}{\code{S3FileSystem$file_tag_delete()}}
\item \href{#method-S3FileSystem-file_tag_info}{\code{S3FileSystem$file_tag_info()}}
\item \href{#method-S3FileSystem-file_tag_update}{\code{S3FileSystem$file_tag_update()}}
\item \href{#method-S3FileSystem-file_touch}{\code{S3FileSystem$file_touch()}}
\item \href{#method-S3FileSystem-file_upload}{\code{S3FileSystem$file_upload()}}
\item \href{#method-S3FileSystem-file_url}{\code{S3FileSystem$file_url()}}
\item \href{#method-S3FileSystem-file_version_info}{\code{S3FileSystem$file_version_info()}}
\item \href{#method-S3FileSystem-is_file}{\code{S3FileSystem$is_file()}}
\item \href{#method-S3FileSystem-is_dir}{\code{S3FileSystem$is_dir()}}
\item \href{#method-S3FileSystem-is_bucket}{\code{S3FileSystem$is_bucket()}}
\item \href{#method-S3FileSystem-is_file_empty}{\code{S3FileSystem$is_file_empty()}}
\item \href{#method-S3FileSystem-bucket_chmod}{\code{S3FileSystem$bucket_chmod()}}
\item \href{#method-S3FileSystem-bucket_create}{\code{S3FileSystem$bucket_create()}}
\item \href{#method-S3FileSystem-bucket_delete}{\code{S3FileSystem$bucket_delete()}}
\item \href{#method-S3FileSystem-dir_copy}{\code{S3FileSystem$dir_copy()}}
\item \href{#method-S3FileSystem-dir_create}{\code{S3FileSystem$dir_create()}}
\item \href{#method-S3FileSystem-dir_delete}{\code{S3FileSystem$dir_delete()}}
\item \href{#method-S3FileSystem-dir_exists}{\code{S3FileSystem$dir_exists()}}
\item \href{#method-S3FileSystem-dir_download}{\code{S3FileSystem$dir_download()}}
\item \href{#method-S3FileSystem-dir_info}{\code{S3FileSystem$dir_info()}}
\item \href{#method-S3FileSystem-dir_ls}{\code{S3FileSystem$dir_ls()}}
\item \href{#method-S3FileSystem-dir_ls_url}{\code{S3FileSystem$dir_ls_url()}}
\item \href{#method-S3FileSystem-dir_tree}{\code{S3FileSystem$dir_tree()}}
\item \href{#method-S3FileSystem-dir_upload}{\code{S3FileSystem$dir_upload()}}
\item \href{#method-S3FileSystem-path}{\code{S3FileSystem$path()}}
\item \href{#method-S3FileSystem-path_dir}{\code{S3FileSystem$path_dir()}}
\item \href{#method-S3FileSystem-path_ext}{\code{S3FileSystem$path_ext()}}
\item \href{#method-S3FileSystem-path_ext_remove}{\code{S3FileSystem$path_ext_remove()}}
\item \href{#method-S3FileSystem-path_ext_set}{\code{S3FileSystem$path_ext_set()}}
\item \href{#method-S3FileSystem-path_file}{\code{S3FileSystem$path_file()}}
\item \href{#method-S3FileSystem-path_join}{\code{S3FileSystem$path_join()}}
\item \href{#method-S3FileSystem-path_split}{\code{S3FileSystem$path_split()}}
\item \href{#method-S3FileSystem-clear_cache}{\code{S3FileSystem$clear_cache()}}
\item \href{#method-S3FileSystem-clone}{\code{S3FileSystem$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-new"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-new}{}}}
\subsection{Method \code{new()}}{
Initialize S3FileSystem class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$new(
  aws_access_key_id = NULL,
  aws_secret_access_key = NULL,
  aws_session_token = NULL,
  region_name = NULL,
  profile_name = NULL,
  endpoint = NULL,
  disable_ssl = FALSE,
  multipart_threshold = fs_bytes("2GB"),
  request_payer = FALSE,
  anonymous = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{aws_access_key_id}}{(character): AWS access key ID}

\item{\code{aws_secret_access_key}}{(character): AWS secret access key}

\item{\code{aws_session_token}}{(character): AWS temporary session token}

\item{\code{region_name}}{(character): Default region when creating new connections}

\item{\code{profile_name}}{(character): The name of a profile to use. If not given,
then the default profile is used.}

\item{\code{endpoint}}{(character): The complete URL to use for the constructed client.}

\item{\code{disable_ssl}}{(logical): Whether or not to use SSL. By default, SSL is used.}

\item{\code{multipart_threshold}}{(\link[fs]{fs_bytes}): Threshold to use multipart instead of standard
copy and upload methods.}

\item{\code{request_payer}}{(logical): Confirms that the requester knows that they
will be charged for the request.}

\item{\code{anonymous}}{(logical): Set up anonymous credentials when connecting to AWS S3.}

\item{\code{...}}{Other parameters within \code{paws} client.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-file_chmod"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-file_chmod}{}}}
\subsection{Method \code{file_chmod()}}{
Change file permissions
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$file_chmod(
  path,
  mode = c("private", "public-read", "public-read-write", "authenticated-read",
    "aws-exec-read", "bucket-owner-read", "bucket-owner-full-control")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character): A character vector of path or s3 uri.}

\item{\code{mode}}{(character): A character of the mode}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character vector of s3 uri paths
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-file_copy"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-file_copy}{}}}
\subsection{Method \code{file_copy()}}{
copy files
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$file_copy(
  path,
  new_path,
  max_batch = fs_bytes("100MB"),
  overwrite = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character): path to a local directory of file or a uri.}

\item{\code{new_path}}{(character): path to a local directory of file or a uri.}

\item{\code{max_batch}}{(\link[fs]{fs_bytes}): Maximum batch size being uploaded with each multipart.}

\item{\code{overwrite}}{(logical): Overwrite files if the exist. If this is \code{FALSE}
and the file exists an error will be thrown.}

\item{\code{...}}{parameters to be passed to \code{\link[paws.storage]{s3_put_object}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character vector of s3 uri paths
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-file_create"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-file_create}{}}}
\subsection{Method \code{file_create()}}{
Create file on AWS S3, if file already
exists it will be left unchanged.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$file_create(path, overwrite = FALSE, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character): A character vector of path or s3 uri.}

\item{\code{overwrite}}{(logical): Overwrite files if the exist. If this is \code{FALSE}
and the file exists an error will be thrown.}

\item{\code{...}}{parameters to be passed to \code{\link[paws.storage]{s3_put_object}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character vector of s3 uri paths
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-file_delete"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-file_delete}{}}}
\subsection{Method \code{file_delete()}}{
Delete files in AWS S3
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$file_delete(path, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character): A character vector of paths or s3 uris.}

\item{\code{...}}{parameters to be passed to \code{\link[paws.storage]{s3_delete_objects}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character vector of s3 uri paths
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-file_download"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-file_download}{}}}
\subsection{Method \code{file_download()}}{
Downloads AWS S3 files to local
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$file_download(path, new_path, overwrite = FALSE, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character): A character vector of paths or uris}

\item{\code{new_path}}{(character): A character vector of paths to the new locations.}

\item{\code{overwrite}}{(logical): Overwrite files if the exist. If this is \code{FALSE}
and the file exists an error will be thrown.}

\item{\code{...}}{parameters to be passed to \code{\link[paws.storage]{s3_get_object}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character vector of s3 uri paths
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-file_exists"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-file_exists}{}}}
\subsection{Method \code{file_exists()}}{
Check if file exists in AWS S3
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$file_exists(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character) s3 path to check}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
logical vector if file exists
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-file_info"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-file_info}{}}}
\subsection{Method \code{file_info()}}{
Returns file information within AWS S3 directory
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$file_info(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character): A character vector of paths or uris.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data.table with metadata for each file. Columns returned are as follows.
\itemize{
\item{bucket_name} {(character): AWS S3 bucket of file}
\item{key} {(character): AWS S3 path key of file}
\item{uri} {(character): S3 uri of file}
\item{size} {(numeric): file size in bytes}
\item{type} {(character): file type (file or directory)}
\item{etag} {(character): An entity tag is an opague identifier}
\item{last_modified} {(POSIXct): Created date of file.}
\item{delete_marker} {(logical): Specifies retrieved a logical marker}
\item{accept_ranges} {(character): Indicates that a range of bytes was specified.}
\item{expiration} {(character): File expiration}
\item{restore} {(character): If file is archived}
\item{archive_status} {(character): Archive status}
\item{missing_meta} {(integer): Number of metadata entries not returned in "x-amz-meta" headers}
\item{version_id} {(character): version id of file}
\item{cache_control} {(character): caching behaviour for the request/reply chain}
\item{content_disposition} {(character): presentational information of file}
\item{content_encoding} {(character): file content encodings}
\item{content_language} {(character): what language the content is in}
\item{content_type} {(character): file MIME type}
\item{expires} {(POSIXct): date and time the file is no longer cacheable}
\item{website_redirect_location} {(character): redirects request for file to another}
\item{server_side_encryption} {(character): File server side encryption}
\item{metadata} {(list): metadata of file}
\item{sse_customer_algorithm} {(character): server-side encryption with a customer-provided encryption key}
\item{sse_customer_key_md5} {(character): server-side encryption with a customer-provided encryption key}
\item{ssekms_key_id} {(character): ID of the Amazon Web Services Key Management Service}
\item{bucket_key_enabled} {(logical): s3 bucket key for server-side encryption with}
\item{storage_class} {(character): file storage class information}
\item{request_charged} {(character): indicates successfully charged for request}
\item{replication_status} {(character): return specific header if request
involves a bucket that is either a source or a destination in a replication rule
\url{https://boto3.amazonaws.com/v1/documentation/api/latest/reference/services/s3.html#S3.Client.head_object}}
\item{parts_count} {(integer): number of count parts the file has}
\item{object_lock_mode} {(character): the file lock mode}
\item{object_lock_retain_until_date} {(POSIXct): date and time of when object_lock_mode expires}
\item{object_lock_legal_hold_status} {(character): file legal holding}
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-file_move"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-file_move}{}}}
\subsection{Method \code{file_move()}}{
Move files to another location on AWS S3
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$file_move(
  path,
  new_path,
  max_batch = fs_bytes("100MB"),
  overwrite = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character): A character vector of s3 uri}

\item{\code{new_path}}{(character): A character vector of s3 uri.}

\item{\code{max_batch}}{(\link[fs]{fs_bytes}): Maximum batch size being uploaded with each multipart.}

\item{\code{overwrite}}{(logical): Overwrite files if the exist. If this is \code{FALSE}
and the file exists an error will be thrown.}

\item{\code{...}}{parameters to be passed to \code{\link[paws.storage]{s3_copy_object}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character vector of s3 uri paths
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-file_size"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-file_size}{}}}
\subsection{Method \code{file_size()}}{
Return file size in bytes
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$file_size(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character): A character vector of s3 uri}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-file_stream_in"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-file_stream_in}{}}}
\subsection{Method \code{file_stream_in()}}{
Streams in AWS S3 file as a raw vector
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$file_stream_in(path, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character): A character vector of paths or s3 uri}

\item{\code{...}}{parameters to be passed to \code{\link[paws.storage]{s3_get_object}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
list of raw vectors containing the contents of the file
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-file_stream_out"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-file_stream_out}{}}}
\subsection{Method \code{file_stream_out()}}{
Streams out raw vector to AWS S3 file
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$file_stream_out(
  obj,
  path,
  max_batch = fs_bytes("100MB"),
  overwrite = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{obj}}{(raw|character): A raw vector, rawConnection, url to be streamed up to AWS S3.}

\item{\code{path}}{(character): A character vector of paths or s3 uri}

\item{\code{max_batch}}{(\link[fs]{fs_bytes}): Maximum batch size being uploaded with each multipart.}

\item{\code{overwrite}}{(logical): Overwrite files if the exist. If this is \code{FALSE}
and the file exists an error will be thrown.}

\item{\code{...}}{parameters to be passed to \code{\link[paws.storage]{s3_put_object}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character vector of s3 uri paths
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-file_temp"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-file_temp}{}}}
\subsection{Method \code{file_temp()}}{
return the name which can be used as a temporary file
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$file_temp(pattern = "file", tmp_dir = "", ext = "")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pattern}}{(character): A character vector with the non-random portion of the name.}

\item{\code{tmp_dir}}{(character): The directory the file will be created in.}

\item{\code{ext}}{(character): A character vector of one or more paths.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character vector of s3 uri paths
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-file_tag_delete"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-file_tag_delete}{}}}
\subsection{Method \code{file_tag_delete()}}{
Delete file tags
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$file_tag_delete(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character): A character vector of paths or s3 uri}

\item{\code{...}}{parameters to be passed to \code{\link[paws.storage]{s3_put_object}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character vector of s3 uri paths
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-file_tag_info"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-file_tag_info}{}}}
\subsection{Method \code{file_tag_info()}}{
Get file tags
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$file_tag_info(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character): A character vector of paths or s3 uri}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
data.table of file version metadata
\itemize{
\item{bucket_name} {(character): AWS S3 bucket of file}
\item{key} {(character): AWS S3 path key of file}
\item{uri} {(character): S3 uri of file}
\item{size} {(numeric): file size in bytes}
\item{version_id} {(character): version id of file}
\item{tag_key} {(character): name of tag}
\item{tag_value} {(character): tag value}
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-file_tag_update"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-file_tag_update}{}}}
\subsection{Method \code{file_tag_update()}}{
Update file tags
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$file_tag_update(path, tags, overwrite = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character): A character vector of paths or s3 uri}

\item{\code{tags}}{(list): Tags to be applied}

\item{\code{overwrite}}{(logical): To overwrite tagging or to modify inplace. Default will
modify inplace.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character vector of s3 uri paths
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-file_touch"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-file_touch}{}}}
\subsection{Method \code{file_touch()}}{
Similar to \code{fs::file_touch} this does not create the file if
it does not exist. Use \code{s3fs$file_create()} to do this if needed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$file_touch(path, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character): A character vector of paths or s3 uri}

\item{\code{...}}{parameters to be passed to \code{\link[paws.storage]{s3_copy_object}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character vector of s3 uri paths
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-file_upload"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-file_upload}{}}}
\subsection{Method \code{file_upload()}}{
Uploads files to AWS S3
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$file_upload(
  path,
  new_path,
  max_batch = fs_bytes("100MB"),
  overwrite = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character): A character vector of local file paths to upload to AWS S3}

\item{\code{new_path}}{(character): A character vector of AWS S3 paths or uri's of the new locations.}

\item{\code{max_batch}}{(\link[fs]{fs_bytes}): Maximum batch size being uploaded with each multipart.}

\item{\code{overwrite}}{(logical): Overwrite files if the exist. If this is \code{FALSE}
and the file exists an error will be thrown.}

\item{\code{...}}{parameters to be passed to \code{\link[paws.storage]{s3_put_object}}
and \code{\link[paws.storage]{s3_create_multipart_upload}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character vector of s3 uri paths
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-file_url"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-file_url}{}}}
\subsection{Method \code{file_url()}}{
Generate presigned url for S3 object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$file_url(path, expiration = 3600L, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character): A character vector of paths or uris}

\item{\code{expiration}}{(numeric): The number of seconds the presigned url is
valid for. By default it expires in an hour (3600 seconds)}

\item{\code{...}}{parameters passed to \code{\link[paws.storage]{s3_get_object}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
return character of urls
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-file_version_info"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-file_version_info}{}}}
\subsection{Method \code{file_version_info()}}{
Get file versions
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$file_version_info(path, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character): A character vector of paths or uris}

\item{\code{...}}{parameters to be passed to \code{\link[paws.storage]{s3_list_object_versions}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
return data.table with file version info, columns below:
\itemize{
\item{bucket_name} {(character): AWS S3 bucket of file}
\item{key} {(character): AWS S3 path key of file}
\item{uri} {(character): S3 uri of file}
\item{size} {(numeric): file size in bytes}
\item{version_id} {(character): version id of file}
\item{owner} {(character): file owner}
\item{etag} {(character): An entity tag is an opague identifier}
\item{last_modified} {(POSIXct): Created date of file.}
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-is_file"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-is_file}{}}}
\subsection{Method \code{is_file()}}{
Test for file types
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$is_file(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character): A character vector of paths or uris}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
logical vector if object is a file
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-is_dir"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-is_dir}{}}}
\subsection{Method \code{is_dir()}}{
Test for file types
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$is_dir(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character): A character vector of paths or uris}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
logical vector if object is a directory
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-is_bucket"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-is_bucket}{}}}
\subsection{Method \code{is_bucket()}}{
Test for file types
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$is_bucket(path, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character): A character vector of paths or uris}

\item{\code{...}}{parameters to be passed to \code{\link[paws.storage]{s3_list_objects_v2}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
logical vector if object is a \verb{AWS S3} bucket
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-is_file_empty"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-is_file_empty}{}}}
\subsection{Method \code{is_file_empty()}}{
Test for file types
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$is_file_empty(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character): A character vector of paths or uris}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
logical vector if file is empty
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-bucket_chmod"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-bucket_chmod}{}}}
\subsection{Method \code{bucket_chmod()}}{
Change bucket permissions
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$bucket_chmod(
  path,
  mode = c("private", "public-read", "public-read-write", "authenticated-read")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character): A character vector of path or s3 uri.}

\item{\code{mode}}{(character): A character of the mode}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character vector of s3 uri paths
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-bucket_create"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-bucket_create}{}}}
\subsection{Method \code{bucket_create()}}{
Create bucket
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$bucket_create(
  path,
  region_name = NULL,
  mode = c("private", "public-read", "public-read-write", "authenticated-read"),
  versioning = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character): A character vector of path or s3 uri.}

\item{\code{region_name}}{(character): aws region}

\item{\code{mode}}{(character): A character of the mode}

\item{\code{versioning}}{(logical): Whether to set the bucket to versioning or not.}

\item{\code{...}}{parameters to be passed to \code{\link[paws.storage]{s3_create_bucket}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character vector of s3 uri paths
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-bucket_delete"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-bucket_delete}{}}}
\subsection{Method \code{bucket_delete()}}{
Delete bucket
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$bucket_delete(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character): A character vector of path or s3 uri.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-dir_copy"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-dir_copy}{}}}
\subsection{Method \code{dir_copy()}}{
Copies the directory recursively to the new location.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$dir_copy(
  path,
  new_path,
  max_batch = fs_bytes("100MB"),
  overwrite = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character): path to a local directory of file or a uri.}

\item{\code{new_path}}{(character): path to a local directory of file or a uri.}

\item{\code{max_batch}}{(\link[fs]{fs_bytes}): Maximum batch size being uploaded with each multipart.}

\item{\code{overwrite}}{(logical): Overwrite files if the exist. If this is \code{FALSE}
and the file exists an error will be thrown.}

\item{\code{...}}{parameters to be passed to \code{\link[paws.storage]{s3_put_object}}
and \code{\link[paws.storage]{s3_create_multipart_upload}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character vector of s3 uri paths
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-dir_create"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-dir_create}{}}}
\subsection{Method \code{dir_create()}}{
Create empty directory
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$dir_create(path, overwrite = FALSE, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character): A vector of directory or uri to be created in AWS S3}

\item{\code{overwrite}}{(logical): Overwrite files if the exist. If this is \code{FALSE}
and the file exists an error will be thrown.}

\item{\code{...}}{parameters to be passed to \code{\link[paws.storage]{s3_put_object}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character vector of s3 uri paths
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-dir_delete"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-dir_delete}{}}}
\subsection{Method \code{dir_delete()}}{
Delete contents and directory in AWS S3
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$dir_delete(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character): A vector of paths or uris to directories to be deleted.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character vector of s3 uri paths
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-dir_exists"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-dir_exists}{}}}
\subsection{Method \code{dir_exists()}}{
Check if path exists in AWS S3
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$dir_exists(path = ".")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character) aws s3 path to be checked}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character vector of s3 uri paths
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-dir_download"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-dir_download}{}}}
\subsection{Method \code{dir_download()}}{
Downloads AWS S3 files to local
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$dir_download(path, new_path, overwrite = FALSE, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character): A character vector of paths or uris}

\item{\code{new_path}}{(character): A character vector of paths to the new locations.
Please ensure directories end with a \code{/}.}

\item{\code{overwrite}}{(logical): Overwrite files if the exist. If this is \code{FALSE}
and the file exists an error will be thrown.}

\item{\code{...}}{parameters to be passed to \code{\link[paws.storage]{s3_get_object}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character vector of s3 uri paths
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-dir_info"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-dir_info}{}}}
\subsection{Method \code{dir_info()}}{
Returns file information within AWS S3 directory
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$dir_info(
  path = ".",
  type = c("any", "bucket", "directory", "file"),
  glob = NULL,
  regexp = NULL,
  invert = FALSE,
  recurse = FALSE,
  refresh = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character):A character vector of one or more paths. Can be path
or s3 uri.}

\item{\code{type}}{(character): File type(s) to return. Default ("any") returns all
AWS S3 object types.}

\item{\code{glob}}{(character): A wildcard pattern (e.g. \code{*.csv}), passed onto
\code{grep()} to filter paths.}

\item{\code{regexp}}{(character): A regular expression (e.g. \code{[.]csv$}),
passed onto \code{grep()} to filter paths.}

\item{\code{invert}}{(logical): If \code{code} return files which do not match.}

\item{\code{recurse}}{(logical): Returns all AWS S3 objects in lower sub directories}

\item{\code{refresh}}{(logical): Refresh cached in \code{s3_cache}.}

\item{\code{...}}{parameters to be passed to \code{\link[paws.storage]{s3_list_objects_v2}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
data.table with directory metadata
\itemize{
\item{bucket_name} {(character): AWS S3 bucket of file}
\item{key} {(character): AWS S3 path key of file}
\item{uri} {(character): S3 uri of file}
\item{size} {(numeric): file size in bytes}
\item{version_id} {(character): version id of file}
\item{etag} {(character): An entity tag is an opague identifier}
\item{last_modified} {(POSIXct): Created date of file}
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-dir_ls"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-dir_ls}{}}}
\subsection{Method \code{dir_ls()}}{
Returns file name within AWS S3 directory
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$dir_ls(
  path = ".",
  type = c("any", "bucket", "directory", "file"),
  glob = NULL,
  regexp = NULL,
  invert = FALSE,
  recurse = FALSE,
  refresh = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character):A character vector of one or more paths. Can be path
or s3 uri.}

\item{\code{type}}{(character): File type(s) to return. Default ("any") returns all
AWS S3 object types.}

\item{\code{glob}}{(character): A wildcard pattern (e.g. \code{*.csv}), passed onto
\code{grep()} to filter paths.}

\item{\code{regexp}}{(character): A regular expression (e.g. \code{[.]csv$}),
passed onto \code{grep()} to filter paths.}

\item{\code{invert}}{(logical): If \code{code} return files which do not match.}

\item{\code{recurse}}{(logical): Returns all AWS S3 objects in lower sub directories}

\item{\code{refresh}}{(logical): Refresh cached in \code{s3_cache}.}

\item{\code{...}}{parameters to be passed to \code{\link[paws.storage]{s3_list_objects_v2}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character vector of s3 uri paths
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-dir_ls_url"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-dir_ls_url}{}}}
\subsection{Method \code{dir_ls_url()}}{
Generate presigned url to list S3 directories
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$dir_ls_url(path, expiration = 3600L, recurse = FALSE, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character): A character vector of paths or uris}

\item{\code{expiration}}{(numeric): The number of seconds the presigned url is
valid for. By default it expires in an hour (3600 seconds)}

\item{\code{recurse}}{(logical): Returns all AWS S3 objects in lower sub directories}

\item{\code{...}}{parameters passed to \code{\link[paws.storage]{s3_list_objects_v2}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
return character of urls
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-dir_tree"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-dir_tree}{}}}
\subsection{Method \code{dir_tree()}}{
Print contents of directories in a tree-like format
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$dir_tree(path, recurse = TRUE, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character): path A path to print the tree from}

\item{\code{recurse}}{(logical): Returns all AWS S3 objects in lower sub directories}

\item{\code{...}}{Additional arguments passed to \link{s3_dir_ls}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character vector of s3 uri paths
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-dir_upload"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-dir_upload}{}}}
\subsection{Method \code{dir_upload()}}{
Uploads local directory to AWS S3
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$dir_upload(
  path,
  new_path,
  max_batch = fs_bytes("100MB"),
  overwrite = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character): A character vector of local file paths to upload to AWS S3}

\item{\code{new_path}}{(character): A character vector of AWS S3 paths or uri's of the new locations.}

\item{\code{max_batch}}{(\link[fs]{fs_bytes}): Maximum batch size being uploaded with each multipart.}

\item{\code{overwrite}}{(logical): Overwrite files if the exist. If this is \code{FALSE}
and the file exists an error will be thrown.}

\item{\code{...}}{parameters to be passed to \code{\link[paws.storage]{s3_put_object}}
and \code{\link[paws.storage]{s3_create_multipart_upload}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character vector of s3 uri paths
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-path"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-path}{}}}
\subsection{Method \code{path()}}{
Constructs a s3 uri path
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$path(..., ext = "")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{(character): Character vectors}

\item{\code{ext}}{(character): An optional extension to append to the generated path}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character vector of s3 uri paths
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-path_dir"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-path_dir}{}}}
\subsection{Method \code{path_dir()}}{
Returns the directory portion of s3 uri
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$path_dir(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character): A character vector of paths}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character vector of s3 uri paths
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-path_ext"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-path_ext}{}}}
\subsection{Method \code{path_ext()}}{
Returns the last extension for a path.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$path_ext(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character): A character vector of paths}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character s3 uri file extension
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-path_ext_remove"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-path_ext_remove}{}}}
\subsection{Method \code{path_ext_remove()}}{
Removes the last extension and return the rest of the s3 uri.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$path_ext_remove(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character): A character vector of paths}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character vector of s3 uri paths
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-path_ext_set"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-path_ext_set}{}}}
\subsection{Method \code{path_ext_set()}}{
Replace the extension with a new extension.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$path_ext_set(path, ext)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character): A character vector of paths}

\item{\code{ext}}{(character): New file extension}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character vector of s3 uri paths
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-path_file"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-path_file}{}}}
\subsection{Method \code{path_file()}}{
Returns the file name portion of the s3 uri path
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$path_file(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character): A character vector of paths}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character vector of file names
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-path_join"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-path_join}{}}}
\subsection{Method \code{path_join()}}{
Construct an s3 uri path from path vector
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$path_join(parts)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parts}}{(character): A character vector of one or more paths}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character vector of s3 uri paths
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-path_split"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-path_split}{}}}
\subsection{Method \code{path_split()}}{
Split s3 uri path to core components bucket, key and version id
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$path_split(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character): A character vector of one or more paths or s3 uri}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
list character vectors splitting the s3 uri path in "Bucket", "Key" and "VersionId"
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-clear_cache"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-clear_cache}{}}}
\subsection{Method \code{clear_cache()}}{
Clear S3 Cache
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$clear_cache(path = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character): s3 path to be cl}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-S3FileSystem-clone"></a>}}
\if{latex}{\out{\hypertarget{method-S3FileSystem-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{S3FileSystem$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
