% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_system.R
\name{stream}
\alias{stream}
\alias{s3_file_stream_in}
\alias{s3_file_stream_out}
\title{Streams data from R to AWS S3.}
\usage{
s3_file_stream_in(path, ...)

s3_file_stream_out(
  obj,
  path,
  max_batch = fs_bytes("100MB"),
  overwrite = FALSE,
  ...
)
}
\arguments{
\item{path}{(character): A character vector of paths or s3 uri}

\item{...}{parameters to be passed to \code{\link[paws.storage]{s3_get_object}} and
\code{\link[paws.storage]{s3_put_object}}}

\item{obj}{(raw|character): A raw vector, rawConnection, url to be streamed up to AWS S3.}

\item{max_batch}{(\link[fs]{fs_bytes}): Maximum batch size being uploaded with each multipart.}

\item{overwrite}{(logical): Overwrite files if the exist. If this is \code{FALSE}
and the file exists an error will be thrown.}
}
\value{
list of raw vectors containing the contents of the file
}
\description{
\code{s3_file_stream_in} streams in AWS S3 file as a raw vector

\code{s3_file_stream_out} streams raw vector out to AWS S3 file
}
\examples{
\dontrun{
# Require AWS S3 credentials

obj = list(charToRaw("contents1"), charToRaw("contents2"))

dir = s3_file_temp(tmp_dir = "MyBucket")
path = s3_path(dir, letters[1:2], ext = "txt")

s3_file_stream_out(obj, path)
s3_file_stream_in(path)
}
}
