% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_system.R
\name{download}
\alias{download}
\alias{s3_file_download}
\alias{s3_dir_download}
\title{Download files and directories}
\usage{
s3_file_download(path, new_path, overwrite = FALSE, ...)

s3_dir_download(path, new_path, overwrite = FALSE, ...)
}
\arguments{
\item{path}{(character): A character vector of paths or uris}

\item{new_path}{(character): A character vector of paths to the new locations.}

\item{overwrite}{(logical): Overwrite files if the exist. If this is \code{FALSE}
and the file exists an error will be thrown.}

\item{...}{parameters to be passed to \code{\link[paws.storage]{s3_get_object}}}
}
\value{
character vector of s3 uri paths
}
\description{
\code{s3_file_download} downloads \verb{AWS S3} files to local

\code{s3_file_download} downloads \verb{AWS s3} directory to local
}
\examples{
\dontrun{
# Require AWS S3 credentials

temp_file = s3_file_temp(tmp_dir= "MyBucket")
s3_file_create(temp_file)

s3_file_download(temp_file, "temp_file.txt")
}
}
