% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StatSeasAtlHurr.R
\name{StatSeasAtlHurr}
\alias{StatSeasAtlHurr}
\title{Compute estimate of seasonal mean of Atlantic hurricane activity}
\usage{
StatSeasAtlHurr(atlano, tropano, hrvar = "HR", ncores = NULL)
}
\arguments{
\item{atlano}{A numeric array with named dimensions of Atlantic sea surface 
temperature anomalies. It must have the same dimensions as 'tropano'.}

\item{tropano}{A numeric array with named dimensions of tropical sea surface 
temperature anomalies. It must have the same dimensions as 'atlano'.}

\item{hrvar}{A character string of the seasonal average to be estimated. The
options are either "HR" (hurricanes), "TC" (tropical cyclones with lifetime
>=48h), or "PDI" (power dissipation index). The default value is 'HR'.}

\item{ncores}{An integer indicating the number of cores to use for parallel 
computation. The default value is NULL.}
}
\value{
A list composed of two arrays with the same dimensions as 'atlano' 
 and 'tropano'.
\item{$mean}{
 The mean of the desired quantity.
}
\item{$var}{
 The variance of that quantity.
}
}
\description{
Compute one of G. Villarini's statistically downscaled measure of mean 
Atlantic hurricane activity and its variance. The hurricane activity is 
estimated using seasonal averages of sea surface temperature anomalies over 
the tropical Atlantic (bounded by 10N-25N and 80W-20W) and the tropics at 
large (bounded by 30N-30S). The anomalies are for the JJASON season.\cr
The estimated seasonal average is either 1) number of hurricanes, 2) number 
of tropical cyclones with lifetime >=48h or 3) power dissipation index 
(PDI; in 10^11 m^3 s^{-2}).\cr
The statistical models used in this function are described in references.
}
\examples{
# Let AtlAno represents 5 different 5-year forecasts of seasonally averaged 
# Atlantic sea surface temperature anomalies.
AtlAno <- array(runif(25, -1, 1), dim = c(sdate = 5, ftime = 5))
# Let TropAno represents 5 corresponding 5-year forecasts of seasonally 
# averaged tropical sea surface temperature anomalies.
TropAno <- array(runif(25, -1, 1), dim = c(sdate = 5, ftime = 5))
# The seasonal average of hurricanes for each of the five forecasted years, 
# for each forecast, would then be given by.
hr_count <- StatSeasAtlHurr(atlano = AtlAno, tropano = TropAno, hrvar = 'HR')

}
\references{
Villarini et al. (2010) Mon Wea Rev, 138, 2681-2705.\cr
Villarini et al. (2012) Mon Wea Rev, 140, 44-65.\cr
Villarini et al. (2012) J Clim, 25, 625-637.\cr
An example of how the function can be used in hurricane forecast studies 
 is given in\cr
Caron, L.-P. et al. (2014) Multi-year prediction skill of Atlantic hurricane 
 activity in CMIP5 decadal hindcasts. Climate Dynamics, 42, 2675-2690. 
 doi:10.1007/s00382-013-1773-1.
}
