% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProbBins.R
\name{ProbBins}
\alias{ProbBins}
\title{Compute probabilistic information of a forecast relative to a threshold or a quantile}
\usage{
ProbBins(
  data,
  thr,
  fcyr = "all",
  time_dim = "sdate",
  memb_dim = "member",
  quantile = TRUE,
  compPeriod = "Full period",
  ncores = NULL
)
}
\arguments{
\item{data}{An numeric array of anomalies with the dimensions 'time_dim' and
'memb_dim' at least. It can be generated by \code{Ano()}.}

\item{thr}{A numeric vector used as the quantiles (if 'quantile' is TRUE) or 
thresholds (if 'quantile' is FALSE) to bin the anomalies. If it is quantile,
it must be within [0, 1].}

\item{fcyr}{A numeric vector of the indices of the forecast years (i.e., 
time_dim) to compute the probabilistic bins for, or 'all' to compute the 
bins for all the years. E.g., c(1:5), c(1, 4), 4, or 'all'. The default 
value is 'all'.}

\item{time_dim}{A character string indicating the dimension along which to 
compute the probabilistic bins. The default value is 'sdate'.}

\item{memb_dim}{A character string indicating the name of the member 
dimension or the dimension to be merged with 'time_dim' for probabilistic
calculation. The default value is 'member'.}

\item{quantile}{A logical value indicating if the thresholds ('thr') are 
quantiles (TRUE) or the absolute thresholds of the bins (FALSE). The 
default value is TRUE.}

\item{compPeriod}{A character string referring to three computation options:\cr
"Full period": The probabilities are computed based on 'data';\cr
"Without fcyr": The probabilities are computed based on 'data' with all 
'fcyr' removed;\cr
"Cross-validation": The probabilities are computed based on leave-one-out
cross-validation.\cr
The default value is "Full period".}

\item{ncores}{An integer indicating the number of cores to use for parallel 
computation. The default value is NULL.}
}
\value{
A numeric array of probabilistic information with dimensions:\cr
 c(bin = length of 'thr' + 1, time_dim = length of 'fcyr', memb_dim, the  
 rest of dimensions of 'data')\cr
 The values along the 'bin' dimension take values 0 or 1 depending on which 
 of the 'thr' + 1 cathegories the forecast or observation at the corresponding 
 grid point, time step, member and start date belongs to.
}
\description{
Compute probabilistic bins of a set of forecast years ('fcyr') relative to 
the forecast climatology over the whole period of anomalies, optionally excluding 
the selected forecast years ('fcyr') or the forecast year for which the 
probabilistic bins are being computed (see 'compPeriod').
}
\examples{
\dontshow{
startDates <- c('19851101', '19901101', '19951101', '20001101', '20051101')
sampleData <- s2dv:::.LoadSampleData('tos', c('experiment'),
                                    c('observation'), startDates,
                                    output = 'lonlat',
                                    latmin = 27, latmax = 48,
                                    lonmin = -12, lonmax = 40)
}
clim <- Clim(sampleMap$mod, sampleMap$obs)
ano_exp <- Ano(sampleMap$mod, clim$clim_exp)
PB <- ProbBins(ano_exp, fcyr = 3, thr = c(1/3, 2/3), quantile = TRUE)

}
