% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onewayPlot.R
\name{onewayPlot}
\alias{onewayPlot}
\alias{twosampPlot}
\alias{onewayPlot.default}
\alias{onewayPlot.formula}
\alias{onewayPlot.lm}
\title{One-way Analysis of Variance Plot}
\usage{
onewayPlot(x, ...)

\method{onewayPlot}{default}(
  x,
  f,
  conf.level = 0.95,
  interval.type = "tukey",
  pooled = TRUE,
  strip = TRUE,
  vert = TRUE,
  verbose = FALSE,
  ylabel = deparse(terms(formula)[[2]]),
  flabel = deparse(terms(formula)[[3]]),
  ...
)

\method{onewayPlot}{formula}(
  formula,
  data = parent.frame(),
  conf.level = 0.95,
  interval.type = "tukey",
  pooled = TRUE,
  strip = TRUE,
  vert = TRUE,
  verbose = FALSE,
  ylabel = deparse(terms(formula)[[2]]),
  flabel = deparse(terms(formula)[[3]]),
  ...
)

\method{onewayPlot}{lm}(x, ..., ylabel = nms[1], flabel = nms[2])
}
\arguments{
\item{x}{a vector of responses, a formula object or an lm object}

\item{\dots}{optional arguments.}

\item{f}{if x is a vector of responses then f contains the group labels for
each observation in x. That is, the ith value in f says which group the ith
observation of x belongs to.}

\item{conf.level}{confidence level of the intervals.}

\item{interval.type}{three options for intervals appearing on plot:
'hsd','lsd' or 'ci'.}

\item{pooled}{two options: pooled or unpooled standard deviation used for
plotted intervals.}

\item{strip}{if strip=F, boxplots are displayed instead.}

\item{vert}{if vert=F, horizontal stripplots are displayed instead (boxplots
can only be displayed vertically).}

\item{verbose}{if true, print intervals on console.}

\item{ylabel}{can be used to replace variable name of y by another string.}

\item{flabel}{can be used to replace variable name of f by another string.}

\item{formula}{a symbolic description of the model to be fit.}

\item{data}{an optional data frame in which to evaluate the formula.}
}
\description{
Displays stripplot/boxplot of the reponse variable with intervals by factor
levels. It is used as part of a one-way ANOVA analysis.
}
\section{Methods (by class)}{
\itemize{
\item \code{onewayPlot(default)}: One-way Analysis of Variance Plot

\item \code{onewayPlot(formula)}: One-way Analysis of Variance Plot

\item \code{onewayPlot(lm)}: One-way Analysis of Variance Plot

}}
\examples{

##see example in 'summary1way'

##computer data:
data(computer.df)
onewayPlot(score~selfassess, data = computer.df)


##apple data:
data(apples.df)
twosampPlot(Weight~Propagated, data = apples.df)

##oyster data:
data(oysters.df)
onewayPlot(log(Oysters)~Site, data = oysters.df)

##oyster data:
data(oysters.df)
oyster.fit = lm(log(Oysters)~Site, data = oysters.df)
onewayPlot(oyster.fit)

}
\seealso{
\code{\link{summary1way}}, \code{\link{t.test}}.
}
\keyword{hplot}
