% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s2-matrix.R
\name{s2_closest_feature}
\alias{s2_closest_feature}
\alias{s2_farthest_feature}
\alias{s2_distance_matrix}
\alias{s2_max_distance_matrix}
\alias{s2_contains_matrix}
\alias{s2_within_matrix}
\alias{s2_covers_matrix}
\alias{s2_covered_by_matrix}
\alias{s2_intersects_matrix}
\alias{s2_disjoint_matrix}
\alias{s2_equals_matrix}
\alias{s2_touches_matrix}
\alias{s2_dwithin_matrix}
\alias{s2_may_intersect_matrix}
\title{Matrix Functions}
\usage{
s2_closest_feature(x, y)

s2_farthest_feature(x, y)

s2_distance_matrix(x, y, radius = s2_earth_radius_meters())

s2_max_distance_matrix(x, y, radius = s2_earth_radius_meters())

s2_contains_matrix(x, y, options = s2_options(model = "open"))

s2_within_matrix(x, y, options = s2_options(model = "open"))

s2_covers_matrix(x, y, options = s2_options(model = "closed"))

s2_covered_by_matrix(x, y, options = s2_options(model = "closed"))

s2_intersects_matrix(x, y, options = s2_options())

s2_disjoint_matrix(x, y, options = s2_options())

s2_equals_matrix(x, y, options = s2_options())

s2_touches_matrix(x, y, options = s2_options())

s2_dwithin_matrix(x, y, distance, radius = s2_earth_radius_meters())

s2_may_intersect_matrix(x, y, max_edges_per_cell = 50, max_feature_cells = 4)
}
\arguments{
\item{x, y}{Geography vectors, coerced using \code{\link[=as_s2_geography]{as_s2_geography()}}.
\code{x} is considered the source, where as \code{y} is considered the target.}

\item{radius}{Radius of the earth. Defaults to the average radius of
the earth in meters as defined by \code{\link[=s2_earth_radius_meters]{s2_earth_radius_meters()}}.}

\item{options}{An \code{\link[=s2_options]{s2_options()}} object describing the polygon/polyline
model to use and the snap level.}

\item{distance}{A distance on the surface of the earth in the same units
as \code{radius}.}

\item{max_edges_per_cell}{For \code{\link[=s2_may_intersect_matrix]{s2_may_intersect_matrix()}},
this values controls the nature of the index on \code{y}, with higher values
leading to coarser index. Values should be between 10 and 50; the default
of 50 is adequate for most use cases, but for specialized operations users
may wish to use a lower value to increase performance.}

\item{max_feature_cells}{For \code{\link[=s2_may_intersect_matrix]{s2_may_intersect_matrix()}}, this value
controls the approximation of \code{x} used to identify potential intersections
on \code{y}. The default value of 4 gives the best performance for most operations,
but for specialized operations users may wish to use a higher value to increase
performance.}
}
\value{
A vector of length \code{x}.
}
\description{
These functions are similar to accessors and predicates, but instead of
recycling \code{x} and \code{y} to a common length and returning a vector of that
length, these functions return a vector of length \code{x} with each element
\code{i} containing information about how the entire vector \code{y} relates to
the feature at \code{x[i]}.
}
\examples{
city_names <- c("Vatican City", "San Marino", "Luxembourg")
cities <- s2_data_cities(city_names)
country_names <- s2_data_tbl_countries$name
countries <- s2_data_countries()

# closest feature returns y indices of the closest feature
# for each feature in x
country_names[s2_closest_feature(cities, countries)]

# farthest feature returns y indices of the farthest feature
# for each feature in x
country_names[s2_farthest_feature(cities, countries)]

# predicate matrices
country_names[s2_intersects_matrix(cities, countries)[[1]]]

# distance matrices
s2_distance_matrix(cities, cities)
s2_max_distance_matrix(cities, countries[1:4])

}
\seealso{
See pairwise predicate functions (e.g., \code{\link[=s2_intersects]{s2_intersects()}}).
}
