ode <- rxode2({
  d / dt(x) <- x - a * y
  d / dt(y) <- b * x - 2 * y
})

theta <- c(a = 2, b = 3)

inits <- c(x = 5, y = 6)

ev <- eventTable()
ev$add.sampling(0:20)
test_that("Issue RxODE#7", {
  expect_equal(
    signif(ode$run(theta, ev, inits = inits), 4),
    signif(
      structure(
        c(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 5,
          -2.40071754551626, -0.797988301585019, 1.22933378182598, -0.239704444596136, -0.348264963377904,
          0.239255359463921, 0.0243337721520871, -0.0985726512973105, 0.0338076999382037, 0.0215974578602912,
          -0.0218058805115501, 0.00151386846794905, 0.00736528131914866, -0.00375187710135307, -0.00108202491038639,
          0.00184964000792579, -0.000404287493535257, -0.000505075729548002, 0.000367833646224698, 2.62520250411437e-05,
          6, 0.45363293569764, -2.40405359527816, 0.87596929771682, 0.504418531814149, -0.541059848873197,
          0.0491399580323952, 0.177728504558299, -0.0951738354141269, -0.0240974502909853, 0.045465645261658,
          -0.0108574682212692, -0.0120160673946825, 0.00920670867368558, 0.000426736500397501, -0.00357208543509757,
          0.00139255453780948, 0.000710042867870409, -0.000820305897276105, 9.46241851831113e-05, 0.000260736584117828
        ),
        .Dim = c(21L, 3L), .Dimnames = list(NULL, c("time", "x", "y"))
      ),
      4
    ), tolerance=1e-3)
})
