% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_vignette_docker.R
\name{use_vignette_docker}
\alias{use_vignette_docker}
\title{Use vignette: Docker}
\usage{
use_vignette_docker(
  package = names(get_description()),
  docker_org = NULL,
  docker_registry = "ghcr.io",
  cont = construct_cont(cont = paste(docker_org, package, sep = "/"), default_registry =
    docker_registry)[[1]],
  title = "Docker/Singularity Containers",
  vignette_index_entry = "docker",
  save_dir = here::here(),
  path = file.path(save_dir, "vignettes", "docker.Rmd"),
  output = list(`BiocStyle::html_document` = list(md_extensions = "-autolink_bare_uris")),
  port_in = 8787,
  port_out = 8900,
  force_new = FALSE,
  show = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{package}{R package name.}

\item{docker_org}{Docker registry organization name. 
Can simply be your registry username instead.
If \code{NULL}, \code{docker_org} will be inferred as the R package's GitHub 
owner.}

\item{docker_registry}{Docker container registry to push to. 
Options include:
\describe{
 \item{"ghcr.io" : }{\href{https://docs.github.com/en/packages/working-with-a-github-packages-registry/working-with-the-container-registry}{
 GitHub Container Registry}}  
 \item{"docker.io" : }{\href{https://hub.docker.com/}{DockerHub}}
}}

\item{cont}{Which Docker container to use on each OS
(\code{NULL} means no container will be used for that OS).
See 
\href{https://hub.docker.com/r/bioconductor/bioconductor_docker/tags}{here}
 for a list of all official Bioconductor Docker container versions.}

\item{title}{Title of vignette.}

\item{vignette_index_entry}{Index entry of the vignette, 
which is used when creating the navigation bar in the \pkg{pkgdown} site.}

\item{save_dir}{Directory to save the file to.}

\item{path}{Path to the file.}

\item{output}{Vignette output style. 
Defaults to \link[BiocStyle]{html_document}.}

\item{port_in}{Port number to route into the docker container.
See the 
\href{https://docs.docker.com/config/containers/container-networking/}{
Docker docs} for further details.}

\item{port_out}{Port number to route out of docker container.
See the 
\href{https://docs.docker.com/config/containers/container-networking/}{
Docker docs} for further details.}

\item{force_new}{If the file already exists, overwrite it 
(default: \code{FALSE}).}

\item{show}{Print the contents of the file in the R console.}

\item{verbose}{Print messages.}
}
\value{
Path to vignette file.
}
\description{
Creates a vignette rmarkdown file demonstrates how to create a
 Docker/Singularity image from a container stored in 
\href{https://hub.docker.com/}{Dockerhub}.
}
\examples{
path <- use_vignette_docker(package = "mypackage",
                            docker_org = "neurogenomics",
                            ## use default save_dir in practice
                            save_dir = tempdir())
}
