% Generated by roxygen2 (4.1.1.9000): do not edit by hand
% Please edit documentation in R/rwirelesscom.R
\name{f16pskdemod}
\alias{f16pskdemod}
\title{16-PSK Demodulator}
\usage{
f16pskdemod(r)
}
\arguments{
\item{r}{- received signal}
}
\value{
returns a vector of 1's and 0's, 3 bits per input element (i.e., 8-PSK symbol)
}
\description{
Receives a vector of complex values, r, corresponding to an
8-PSK modulated signal transmitted through a communications channel
(e.g., signal plus noise). Three bits are output for each received symbol
according to the following decision rules
\tabular{cc}{
input \tab output \cr
 \eqn{ -\pi/16 \ge Arg(r) < \pi/16}        \tab 0000  \cr
 \eqn{  \pi/16 \ge Arg(r) < 3 \pi/16}     \tab 0001 \cr
 \eqn{ 3 \pi/16 \ge Arg(r) < 5 \pi/16}     \tab 0011 \cr
 \eqn{ 5 \pi/16 \ge Arg(r) < 7 \pi/16}     \tab 0010 \cr
 \eqn{ 7 \pi/16 \ge Arg(r) < 9 \pi/16}    \tab 0110 \cr
 \eqn{ 9 \pi/16 \ge Arg(r) < 11 \pi/16}   \tab 0111 \cr
 \eqn{ 11 \pi/16 \ge Arg(r) < 13 \pi/16}   \tab 0101 \cr
 \eqn{ 13 \pi/16 \ge Arg(r) < 15 \pi/16}   \tab 0100 \cr
 \eqn{ 15 \pi/16 \ge Arg(r) < 17 \pi/16}   \tab 1100  \cr
 \eqn{ -15 \pi/16 \ge Arg(r) < -13 \pi/16}  \tab 1101 \cr
 \eqn{ -13 \pi/16 \ge Arg(r) < -11 \pi/16} \tab 1111 \cr
 \eqn{ -11 \pi/16 \ge Arg(r) < -9 \pi/16}   \tab 1110 \cr
 \eqn{ -9 \pi/16 \ge Arg(r) < -7 \pi/16}    \tab 1010 \cr
 \eqn{ -7 \pi/16 \ge Arg(r) < -5 \pi/16}    \tab 1011 \cr
 \eqn{ -5 \pi/16 \ge Arg(r) < -3 \pi/16}    \tab 1001 \cr
 \eqn{ -3 \pi/16 \ge Arg(r) < - \pi/16}     \tab 1000
}
}
\examples{
M=16
Es=1
Eb = Es/log2(M)
Nsymbols=20
Nbits=log2(M)*Nsymbols
bits <- sample(0:1,Nbits, replace=TRUE)
s <- f16pskmod(bits)
EbNodB=7
No = Eb/(10^(EbNodB/10))
n <- fNo(Nsymbols,No,type="complex")
r <- s+n
bitsr <- f16pskdemod(r)
biterrs<-bits[bitsr!=bits]
b<-factor(bits)
Pberr=length(biterrs)/length(bits)
}
\seealso{
Other modulation.demodulation.communications: \code{\link{f16pskmod}};
  \code{\link{f16qamdemod}}; \code{\link{f16qammod}};
  \code{\link{f64qamdemod}}; \code{\link{f64qammod}};
  \code{\link{f8pskdemod}}; \code{\link{f8pskmod}};
  \code{\link{fNo}}; \code{\link{fbpskdemod}};
  \code{\link{fbpskmod}}; \code{\link{fqpskdemod}};
  \code{\link{fqpskmod}}; \code{\link{iqdensityplot}};
  \code{\link{iqscatterplot}}
}

