% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ITWT2_PO.R
\name{ITWT2_PO}
\alias{ITWT2_PO}
\title{Inverse 2-d tensor wavelet transform (periodized, orthogonal).}
\usage{
ITWT2_PO(wc, L, qmf)
}
\arguments{
\item{wc}{2-d wavelet transform (n by n array, n dyadic).}

\item{L}{coarse level.}

\item{qmf}{quadrature mirror filter.}
}
\value{
\code{x} 2-d signal reconstructed from wc.
}
\description{
If \code{wc} is the result of a forward 2d wavelet transform,
with \code{wc <- FTWT2_PO(x,L,qmf)}, then \code{x <- ITWT2_PO(wc,L,qmf)}
reconstructs \code{x} exactly.
\code{qmf} is a nice qmf, e.g. one made by \code{\link{MakeONFilter}}.
}
\examples{
qmf <- MakeONFilter('Daubechies', 10)
L <- 0
x <- matrix(rnorm(2^2), ncol=2)
wc <- FTWT2_PO(x, L, qmf)
xr <- ITWT2_PO(wc,L,qmf)
}
\seealso{
\code{\link{FTWT2_PO}}, \code{\link{MakeONFilter}}.
}
