% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soda.R
\name{run_melb}
\alias{run_melb}
\title{API using Socrata to Melbourne pedestrian data}
\usage{
run_melb(year = NULL, sensor = NULL, tz = "", na.rm = FALSE,
  app_token = NULL)
}
\arguments{
\item{year}{An integer or a vector of integers. By default, it's the current
year.}

\item{sensor}{Sensor names. By default, it pulls all the sensors. Use \link{lookup_sensor}
to see the available sensors.}

\item{tz}{Time zone. By default, "" is the current time zone. For this dataset,
the local time zone is "Australia/Melbourne" which would be the most
appropriate, depending on OS.}

\item{na.rm}{Logical. \code{FALSE} is the default suggesting to include \code{NA} in
the dataset. \code{TRUE} removes the \code{NA}s.}

\item{app_token}{Characters giving the application token. A limited number of
requests can be made without an app token (\code{NULL}), but they are subject
to much lower throttling limits than request that do include one. Sign up
for an app token \href{https://data.melbourne.vic.gov.au/profile/app_tokens}{here}.}
}
\value{
A tibble including these variables as follows:
\itemize{
\item Sensor: Sensor name (46 sensors up to date)
\item Date_Time: Date time when the pedestrian counts are recorded
\item Date: Date associated with Date_Time
\item Time: Time of day
\item Count: Hourly counts
}
}
\description{
Provides API using Socrata to Melbourne pedestrian data in a tidy data form.
}
\details{
It provides API using \href{https://dev.socrata.com/foundry/data.melbourne.vic.gov.au/mxb8-wn4w}{Socrata},
where counts are uploaded on a monthly basis. The up-to-date data would be
till the previous month. The data is sourced from \href{https://data.melbourne.vic.gov.au/Transport-Movement/Pedestrian-volume-updated-monthly-/b2ak-trbp}{Melbourne Open Data Portal}. Please
refer to Melbourne Open Data Portal for more details about the dataset and
its policy.
}
\examples{
\dontrun{
  # Retrieve the year 2017
  ped_df17 <- run_melb(year = 2017)
  head(ped_df17)
  
  # Retrieve the year 2017 for Southern Cross Station
  sx_df17 <- run_melb(year = 2017, sensor = "Southern Cross Station")
  head(sx_df17)
}
}
\seealso{
\link{walk_melb}
}
