% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hgrv.R
\name{hgrv}
\alias{hgrv}
\title{Apply the Hermite-Gaussian Radial Velocity (HGRV) Estimation Method}
\usage{
hgrv(obs_wvl, obs_flx, tmp_wvl, tmp_flx, Features, obs_err = NULL, cntm = NULL)
}
\arguments{
\item{obs_wvl}{the vector of wavelengths of the observed spectrum}

\item{obs_flx}{the vector of normalized flux of the observed spectrum}

\item{tmp_wvl}{the vector of wavelengths of the template spectrum}

\item{tmp_flx}{the vector of normalized flux of the template spectrum}

\item{Features}{a dataframe with the wavelength bounds and fitted Gaussian parameters for each absorption feature. The \code{parameters} component of the output from the \code{Gaussfit} function provides this.}

\item{obs_err}{the vector of uncertainties in the normalized flux of the observed spectrum (must be the same length as \code{obs_wvl} and \code{obs_flx})}

\item{cntm}{the vector of continuum values used to normalize the flux of the observed spectrum (must be the same length as \code{obs_wvl} and \code{obs_flx})}
}
\value{
a list with the following components
\item{rv}{the estimated radial velocity in units of m/s}
\item{rv_err}{the standard error of the estimated radial velocity in units of m/s}
\item{n}{the number of data points used in the weighted linear regression}
\item{data}{a list with the observed wavelengths (\code{wvl}), the difference
flux (\code{diff_flux}), the explanatory variable constructed as a sum of
first-degree generalized Hermite-Gaussian functions (\code{hgvar}), and the
weights (\code{weights}) used in the regression.}
}
\description{
This function applies the HGRV method as given in 
\href{https://arxiv.org/abs/2005.14083}{Holzer et al. (2020)} to a given observed spectrum, using
the estimated template from the \code{estimate_template} function and the
\code{parameters} component of the output from the \code{Gaussfit} function.
The result is an estimate of the relative radial velocity present in the
observed spectrum in units of m/s.
}
\examples{
data(template)
ftrs = findabsorptionfeatures(template$Wavelength,
                              template$Flux,
                              pix_range = 8, gamma = 0.05,
                              alpha = 0.07, minlinedepth = 0.015)
gapp = Gaussfit(template$Wavelength, template$Flux, ftrs)
data(observed_spec)
hgrv_output = hgrv(observed_spec$Wavelength, observed_spec$Flux,
                   template$Wavelength, template$Flux, gapp$parameters,
                   obs_err = observed_spec$Uncertainty)
plot(hgrv_output$data$hgvar, hgrv_output$data$diff_flux)
abline(a=0, b=hgrv_output$rv)
abline(a=0, b=hgrv_output$rv - 3*hgrv_output$rv_err, lty=2)
abline(a=0, b=hgrv_output$rv + 3*hgrv_output$rv_err, lty=2)

}
