% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoencoder_contractive.R,
%   R/autoencoder_robust.R, R/autoencoder_variational.R, R/loss.R
\name{to_keras.ruta_loss_contraction}
\alias{to_keras.ruta_loss_contraction}
\alias{to_keras.ruta_loss_correntropy}
\alias{to_keras.ruta_loss_variational}
\alias{to_keras.ruta_loss_named}
\title{Obtain a Keras loss}
\usage{
\method{to_keras}{ruta_loss_contraction}(x, learner, ...)

\method{to_keras}{ruta_loss_correntropy}(x, ...)

\method{to_keras}{ruta_loss_variational}(x, learner, ...)

\method{to_keras}{ruta_loss_named}(x, ...)
}
\arguments{
\item{x}{A \code{"ruta_loss_named"} object}

\item{learner}{The learner object including the keras model which will use the loss
function}

\item{...}{Rest of parameters, ignored}
}
\value{
A function which returns the corresponding loss for given true and
predicted values
}
\description{
Builds the Keras loss function corresponding to a name
}
\references{
\itemize{
\item Contractive loss: \href{https://agustinus.kristia.de/techblog/2016/12/05/contractive-autoencoder/}{Deriving Contractive Autoencoder and Implementing it in Keras}
}

\itemize{
\item Correntropy loss: \href{https://ieeexplore.ieee.org/abstract/document/6854900/}{Robust feature learning by stacked autoencoder with maximum correntropy criterion}
}

\itemize{
\item Variational loss:
\itemize{
\item \href{https://arxiv.org/abs/1312.6114}{Auto-Encoding Variational Bayes}
\item \href{https://blog.fastforwardlabs.com/2016/08/22/under-the-hood-of-the-variational-autoencoder-in.html}{Under the Hood of the Variational Autoencoder (in Prose and Code)}
\item \href{https://github.com/rstudio/keras/blob/main/vignettes/examples/variational_autoencoder.R}{Keras example: Variational autoencoder}
}
}
}
