% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{runner}
\alias{runner}
\title{Custom running function}
\usage{
runner(x, k = 0L, idx = 1L, f = NULL)
}
\arguments{
\item{x}{Vector of any type}

\item{k}{integer vector which specifies window length}

\item{idx}{an optional integer vector containing index of observations.}

\item{f}{R function to be applied on `x`}
}
\description{
Applies custom function to running windows
}
\examples{
runner(1:10, f = mean, k = 3)
runner(1:10, k = 3, f = function(x) mean(x, na.rm = TRUE))
runner(letters[1:10], k = c(1,2,2,4,5,5,5,5,5,5), f = function(x) length(unique(x)))
}
