% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runjagsclass.R
\name{runjags-class}
\alias{runjags-class}
\alias{runjagsclass}
\alias{runjagsstudy-class}
\alias{runjagsstudyclass}
\alias{as.jags}
\alias{as.runjags}
\alias{as.mcmc.runjags}
\alias{as.mcmc.list.runjags}
\alias{cleanup.jags}
\alias{cleanup.JAGS}
\alias{failed.jags}
\alias{failed.JAGS}
\alias{failedjags}
\alias{fitted.runjags}
\alias{residuals.runjags}
\alias{predict.runjags}
\alias{as.jags.runjags}
\alias{as.runjags.jags}
\alias{is.runjags}
\alias{as.jags.default}
\alias{as.runjags.default}
\title{The runjags class and available S3 methods}
\usage{
\method{as.mcmc}{runjags}(x, vars = NA, add.mutate = TRUE, ...)

\method{as.mcmc.list}{runjags}(x, vars = NA, add.mutate = TRUE, ...)

\method{as.jags}{runjags}(x, adapt = 1000, quiet = FALSE, ...)

\method{as.runjags}{jags}(
  jags.model,
  monitor = stop("No monitored variables supplied"),
  modules = runjags.getOption("modules"),
  factories = runjags.getOption("factories"),
  jags = runjags.getOption("jagspath"),
  mutate = NA,
  check = TRUE,
  ...
)

is.runjags(x)

cleanup.jags(all.folders = FALSE, silent = FALSE)

cleanup.JAGS(all.folders = FALSE, silent = FALSE)

failed.jags(show = c("model", "output"))

as.jags(x, adapt = 1000, quiet = FALSE, ...)

\method{as.jags}{default}(x, ...)

as.runjags(jags.model, ...)

\method{as.runjags}{default}(jags.model, ...)

\method{residuals}{runjags}(
  object,
  variable = object$residual,
  show.summary = FALSE,
  output = "mean",
  ...
)

\method{fitted}{runjags}(
  object,
  variable = object$fitted,
  show.summary = FALSE,
  output = "mean",
  ...
)
}
\arguments{
\item{x}{an object of class runjags.}

\item{vars}{an optional character vector of variable names to extract.  If supplied, only variable names in the object supplied with a partial match to anything in 'vars' will be summarised/plotted/extracted.  Note that regular expressions are not allowed, but the caret (^) token can be used to specify the match at the start of a variable name, and a quoted vars will be matched exactly.  Default NA meaning all variables available are returned.}

\item{add.mutate}{option to use the inbuild mutate function to produce additional MCMC variables before returning the MCMC object.}

\item{...}{additional options to be passed to default methods or additional functions.}

\item{adapt}{as for \code{\link[rjags]{jags.model}}}

\item{quiet}{as for \code{\link[rjags]{jags.model}}}

\item{jags.model}{a model produced by \code{\link[rjags]{jags.model}}}

\item{monitor}{a character vector of the names of variables to monitor, as for \code{\link{run.jags}}}

\item{modules}{a character vector of external modules to be loaded into JAGS, either as the module name on its own or as the module name and status separated by a space, for example 'glm on'.}

\item{factories}{a character vector of factory modules to be loaded into JAGS.  Factories should be provided in the format '\<facname\> \<factype\> \<status\>' (where status is optional), for example: factories='mix::TemperedMix sampler on'.  You must also ensure that any required modules are also specified (in this case 'mix').}

\item{jags}{the system call or path for activating JAGS.  Default uses the option given in \code{\link{runjags.options}}.}

\item{mutate}{either a function or a list with first element a function and remaining elements arguments to this function that can be used to add variables to the model output.  See \code{\link{add.summary}} for more details.}

\item{check}{option to check that the model can be (re)-compiled.}

\item{all.folders}{option to remove ALL simulation folders created using keep.jags.files=TRUE and not just unsuccessful simulations.}

\item{silent}{option to suppress feedback when deleting simulation folders.}

\item{show}{which parts of the failed JAGS simulation to display - options are:  'model', 'data', 'inits', 'output', 'end.state', 'all'}

\item{object}{an object of class runjags.}

\item{variable}{the name of the variable within the JAGS simulation that denotes the residual/fitted variable.  This must be specified to be able to use the residuals and fitted methods.}

\item{show.summary}{option to show the full summary statistics of the returned models before extracting just the residuals/fitted variable information.}

\item{output}{the type of output required for the residuals and fitted methods - options are:  'mean', 'mcmc', 'hpd', 'summary', 'runjags'.}
}
\description{
Objects of class 'runjags' are produced by \code{\link{run.jags}}, \code{\link{results.jags}} and \code{\link{autorun.jags}}, and contain the MCMC chains as well as all information required to extend the simulation.  These are a number of utility functions associated with these objects.
}
\details{
The functions and methods detailed here permit conversion of runjags objects to MCMC objects and to/from jags models created by \code{\link[rjags]{jags.model}}.  There are also S3 methods for print, summary and plot available for runjags class objects - see \code{\link{add.summary}} for details of the arguments available to these.
The 'failed.jags' function allows the user to interrogate the details of JAGS models that failed to compile or produce MCMC output.  By default, any simulation folders for models that failed to import are kept until the R session is ended - in some circumstances it may be possible to partially recover the results using \code{\link{results.jags}}.  The cleanup.jags function can be used to remove simulation folders created in the current R session, and is called when the runjags package is unloaded.
}
\examples{
if(require('rjags')){
# Coercion between jags and runjags objects (requires loading the rjags package):
data(LINE)
jags.model <- LINE
runjags.model <- as.runjags(jags.model, monitor=c('alpha','beta'))
\dontrun{
runjags.model <- extend.jags(runjags.model)
jags.model <- as.jags(runjags.model)
# Coercion to MCMC (requires loading the coda package):
library('coda')
mcmc <- as.mcmc.list(runjags.model)
summary(mcmc)
}
}
}
\seealso{
\code{\link{add.summary}} for details on plot, print and summary methods for runjags class objects, \code{\link{extract.runjags}} for a method to extract peripheral information from runjags objects, \code{\link{runjags.options}} for general options available, and \code{\link{run.jags}} and \code{\link{autorun.jags}} for the functions that create objects of this class.
}
\keyword{models}
